/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.migrate;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContentImpl;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeRequestChain;
import com.intellij.openapi.vcs.changes.actions.ChangeDiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentableProxy;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeGoToChangePopupAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigrateToNewDiffUtil {
    private static final Logger LOG = Logger.getInstance(MigrateToNewDiffUtil.class);
    @NonNls
    public static final Object DO_NOT_TRY_MIGRATE = "doNotTryMigrate";

    @NotNull
    public static DiffRequestChain convertRequestChain(@NotNull com.intellij.openapi.diff.DiffRequest oldRequest) {
        ChangeRequestChain oldChain = (ChangeRequestChain)oldRequest.getGenericData().get(VcsDataKeys.DIFF_REQUEST_CHAIN.getName());
        if (oldChain == null || oldChain.getAllRequests().size() < 2) {
            DiffRequest request = MigrateToNewDiffUtil.convertRequest(oldRequest);
            return new SimpleDiffRequestChain(request);
        }
        return new ChangeRequestChainWrapper(oldChain);
    }

    @NotNull
    public static DiffRequest convertRequest(@NotNull com.intellij.openapi.diff.DiffRequest oldRequest) {
        DiffRequest request = MigrateToNewDiffUtil.convertRequestFair(oldRequest);
        if (request != null) {
            return request;
        }
        ErrorDiffRequest erorRequest = new ErrorDiffRequest((DiffRequestProducer)new MyDiffRequestProducer(oldRequest), "Can't convert from old-style request");
        erorRequest.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, Collections.singletonList(new MyShowDiffAction(oldRequest)));
        return erorRequest;
    }

    @Nullable
    private static DiffRequest convertRequestFair(@NotNull com.intellij.openapi.diff.DiffRequest oldRequest) {
        if (oldRequest.getOnOkRunnable() != null) {
            return null;
        }
        com.intellij.openapi.diff.DiffContent[] contents = oldRequest.getContents();
        String[] titles = oldRequest.getContentTitles();
        ArrayList<DiffContent> newContents = new ArrayList<DiffContent>(contents.length);
        for (int i = 0; i < contents.length; ++i) {
            DiffContent convertedContent = MigrateToNewDiffUtil.convertContent(oldRequest.getProject(), contents[i]);
            if (convertedContent == null) {
                return null;
            }
            newContents.add(convertedContent);
        }
        SimpleDiffRequest newRequest = new SimpleDiffRequest(oldRequest.getWindowTitle(), newContents, Arrays.asList(titles));
        newRequest.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, Collections.singletonList(new MyShowDiffAction(oldRequest)));
        DiffNavigationContext navigationContext = (DiffNavigationContext)oldRequest.getGenericData().get(DiffTool.SCROLL_TO_LINE.getName());
        if (navigationContext != null) {
            newRequest.putUserData(DiffUserDataKeysEx.NAVIGATION_CONTEXT, (Object)navigationContext);
        }
        return newRequest;
    }

    @Nullable
    private static DiffContent convertContent(@Nullable Project project2, final @NotNull com.intellij.openapi.diff.DiffContent oldContent) {
        if (oldContent.isEmpty()) {
            return new EmptyContent();
        }
        if (oldContent.isBinary()) {
            VirtualFile file2 = oldContent.getFile();
            if (file2 == null) {
                return null;
            }
            return new FileContentImpl(project2, file2);
        }
        Document document = oldContent.getDocument();
        if (document == null) {
            return null;
        }
        return new DocumentContentImpl(document, oldContent.getContentType(), oldContent.getFile(), oldContent.getLineSeparator(), null){

            @Override
            @Nullable
            public OpenFileDescriptor getOpenFileDescriptor(int offset) {
                return oldContent.getOpenFileDescriptor(offset);
            }

            public void onAssigned(boolean isAssigned) {
                oldContent.onAssigned(isAssigned);
            }
        };
    }

    private static class MyDiffRequestProducer
    implements DiffRequestProducer {
        @NotNull
        private final com.intellij.openapi.diff.DiffRequest myRequest;

        public MyDiffRequestProducer(@NotNull com.intellij.openapi.diff.DiffRequest request) {
            this.myRequest = request;
        }

        @NotNull
        public String getName() {
            return StringUtil.notNullize((String)this.myRequest.getWindowTitle());
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            ErrorDiffRequest errorRequest = new ErrorDiffRequest((DiffRequestProducer)this, "Can't convert from old-style request");
            errorRequest.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, Collections.singletonList(new MyShowDiffAction(this.myRequest)));
            return errorRequest;
        }
    }

    private static class MyShowDiffAction
    extends DumbAwareAction {
        @NotNull
        private final com.intellij.openapi.diff.DiffRequest myRequest;

        public MyShowDiffAction(@NotNull com.intellij.openapi.diff.DiffRequest request) {
            super("Show in old diff tool", null, AllIcons.Diff.Diff);
            this.setEnabledInModalContext(true);
            this.myRequest = request;
            request.addHint(DO_NOT_TRY_MIGRATE);
        }

        public void update(AnActionEvent e) {
            if (!Registry.is((String)"diff.show.old.diff.action.enabled")) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DiffManager.getInstance().getDiffTool().show(this.myRequest);
        }
    }

    private static class MyProducerWrapper
    implements DiffRequestProducer {
        @NotNull
        private final DiffRequestPresentable myPresentable;
        @NotNull
        private final ChangeRequestChain myChain;

        public MyProducerWrapper(@NotNull ChangeRequestChain chain, @NotNull DiffRequestPresentable presentable) {
            this.myPresentable = presentable;
            this.myChain = chain;
        }

        @NotNull
        public String getName() {
            return this.myPresentable.getPathPresentation();
        }

        @NotNull
        public DiffRequestPresentable getPresentable() {
            return this.myPresentable;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            com.intellij.openapi.diff.DiffRequest oldRequest = (com.intellij.openapi.diff.DiffRequest)UIUtil.invokeAndWaitIfNeeded((Computable)new Computable<com.intellij.openapi.diff.DiffRequest>(){

                public com.intellij.openapi.diff.DiffRequest compute() {
                    return myChain.moveTo(myPresentable);
                }
            });
            if (oldRequest == null) {
                return new ErrorDiffRequest((DiffRequestProducer)this, "Can't build old-style request");
            }
            return MigrateToNewDiffUtil.convertRequest(oldRequest);
        }
    }

    private static class ChangeRequestChainWrapper
    extends UserDataHolderBase
    implements DiffRequestChain,
    GoToChangePopupBuilder.Chain {
        @NotNull
        private final ChangeRequestChain myChain;
        @NotNull
        private final List<MyProducerWrapper> myRequests;
        private int myIndex;

        public ChangeRequestChainWrapper(@NotNull ChangeRequestChain chain) {
            this.myChain = chain;
            this.myRequests = ContainerUtil.map((Collection)this.myChain.getAllRequests(), (Function)new Function<DiffRequestPresentable, MyProducerWrapper>(){

                public MyProducerWrapper fun(DiffRequestPresentable presentable) {
                    return new MyProducerWrapper(myChain, presentable);
                }
            });
            this.myIndex = chain.getAllRequests().indexOf(chain.getCurrentRequest());
        }

        @NotNull
        public List<? extends MyProducerWrapper> getRequests() {
            return this.myRequests;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public void setIndex(int index) {
            assert (index >= 0 && index < this.myRequests.size());
            this.myIndex = index;
        }

        @Nullable
        private static Change getChange(@NotNull DiffRequestPresentable presentable) {
            if (presentable instanceof DiffRequestPresentableProxy) {
                try {
                    presentable = ((DiffRequestPresentableProxy)presentable).init();
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                    return null;
                }
            }
            if (presentable instanceof ChangeDiffRequestPresentable) {
                return ((ChangeDiffRequestPresentable)presentable).getChange();
            }
            return null;
        }

        @Override
        @NotNull
        public AnAction createGoToChangeAction(@NotNull Consumer<Integer> onSelected) {
            return new ChangeGoToChangePopupAction<ChangeRequestChainWrapper>(this, onSelected){

                @Override
                @NotNull
                protected List<Change> getChanges() {
                    return ContainerUtil.mapNotNull(((ChangeRequestChainWrapper)this.myChain).getRequests(), (Function)new Function<MyProducerWrapper, Change>(){

                        @Nullable
                        public Change fun(MyProducerWrapper wrapper) {
                            return ChangeRequestChainWrapper.getChange(wrapper.getPresentable());
                        }
                    });
                }

                @Override
                @Nullable
                protected Change getCurrentSelection() {
                    return ChangeRequestChainWrapper.getChange(((ChangeRequestChainWrapper)this.myChain).getRequests().get(myIndex).getPresentable());
                }

                @Override
                protected int findSelectedStep(@Nullable Change change) {
                    if (change == null) {
                        return -1;
                    }
                    for (int i = 0; i < myRequests.size(); ++i) {
                        Change c = ChangeRequestChainWrapper.getChange(((MyProducerWrapper)myRequests.get(i)).getPresentable());
                        if (c == null || !change.equals((Object)c)) continue;
                        return i;
                    }
                    return -1;
                }
            };
        }
    }
}

