/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.Consumer;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeGoToChangePopupAction<Chain extends DiffRequestChain>
extends GoToChangePopupBuilder.BaseGoToChangePopupAction<Chain> {
    public ChangeGoToChangePopupAction(@NotNull Chain chain, @NotNull Consumer<Integer> onSelected) {
        super(chain, onSelected);
    }

    @Override
    @NotNull
    protected JBPopup createPopup(@NotNull AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        Ref popup = new Ref();
        MyChangesBrowser cb = new MyChangesBrowser(project2, this.getChanges(), this.getCurrentSelection(), (Ref<JBPopup>)popup);
        popup.set((Object)JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)cb, cb.getPreferredFocusedComponent()).setResizable(true).setModalContext(false).setFocusable(true).setRequestFocus(true).setCancelOnWindowDeactivation(true).setCancelOnOtherWindowOpen(true).setMovable(true).setCancelKeyEnabled(true).setCancelOnClickOutside(true).setDimensionServiceKey(project2, "Diff.GoToChangePopup", false).createPopup());
        return (JBPopup)popup.get();
    }

    protected abstract int findSelectedStep(@Nullable Change var1);

    @NotNull
    protected abstract List<Change> getChanges();

    @Nullable
    protected abstract Change getCurrentSelection();

    public static abstract class Fake<Chain extends DiffRequestChain>
    extends ChangeGoToChangePopupAction<Chain> {
        @NotNull
        private final List<Change> myChanges;
        private final int mySelection;

        public Fake(@NotNull Chain chain, int selection, @NotNull Consumer<Integer> onSelected) {
            super(chain, onSelected);
            this.mySelection = selection;
            List requests = chain.getRequests();
            this.myChanges = new ArrayList<Change>(requests.size());
            for (int i = 0; i < requests.size(); ++i) {
                FilePath path = this.getFilePath(i);
                FileStatus status = this.getFileStatus(i);
                FakeContentRevision revision = new FakeContentRevision(path);
                this.myChanges.add(new Change((ContentRevision)revision, (ContentRevision)revision, status));
            }
        }

        @NotNull
        protected abstract FilePath getFilePath(int var1);

        @NotNull
        protected abstract FileStatus getFileStatus(int var1);

        @Override
        protected int findSelectedStep(@Nullable Change change) {
            return this.myChanges.indexOf(change);
        }

        @Override
        @NotNull
        protected List<Change> getChanges() {
            return this.myChanges;
        }

        @Override
        @Nullable
        protected Change getCurrentSelection() {
            if (this.mySelection < 0 || this.mySelection >= this.myChanges.size()) {
                return null;
            }
            return this.myChanges.get(this.mySelection);
        }

        private static class FakeContentRevision
        implements ContentRevision {
            @NotNull
            private final FilePath myFilePath;

            public FakeContentRevision(@NotNull FilePath filePath) {
                this.myFilePath = filePath;
            }

            @Nullable
            public String getContent() throws VcsException {
                return null;
            }

            @NotNull
            public FilePath getFile() {
                return this.myFilePath;
            }

            @NotNull
            public VcsRevisionNumber getRevisionNumber() {
                return VcsRevisionNumber.NULL;
            }
        }
    }

    private class MyChangesBrowser
    extends ChangesBrowser
    implements Runnable {
        @NotNull
        private final Ref<JBPopup> myPopup;

        public MyChangesBrowser(@NotNull Project project2, @Nullable List<Change> changes, final @NotNull Change currentChange, Ref<JBPopup> popup) {
            super(project2, null, changes, null, false, false, null, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null);
            this.setSelectionMode(0);
            this.setChangesToDisplay(changes);
            UiNotifyConnector.doWhenFirstShown((JComponent)this, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (currentChange != null) {
                        MyChangesBrowser.this.select(Collections.singletonList(currentChange));
                    }
                }
            });
            this.myPopup = popup;
        }

        @Override
        protected void buildToolBar(DefaultActionGroup toolBarGroup) {
        }

        @Override
        @NotNull
        protected Runnable getDoubleClickHandler() {
            return this;
        }

        @Override
        public void run() {
            Change change = this.getSelectedChanges().get(0);
            final int index = ChangeGoToChangePopupAction.this.findSelectedStep(change);
            ((JBPopup)this.myPopup.get()).cancel();
            IdeFocusManager.getInstance((Project)this.myProject).doWhenFocusSettlesDown(new Runnable(){

                @Override
                public void run() {
                    ChangeGoToChangePopupAction.this.myOnSelected.consume((Object)index);
                }
            });
        }
    }
}

