/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeGoToChangePopupAction;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeDiffRequestChain
extends UserDataHolderBase
implements DiffRequestChain,
GoToChangePopupBuilder.Chain {
    @NotNull
    private final List<ChangeDiffRequestProducer> myRequests;
    private int myIndex;

    public ChangeDiffRequestChain(@NotNull List<ChangeDiffRequestProducer> requests) {
        this.myRequests = requests;
    }

    @NotNull
    public List<? extends ChangeDiffRequestProducer> getRequests() {
        return this.myRequests;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public void setIndex(int index) {
        assert (index >= 0 && index < this.myRequests.size());
        this.myIndex = index;
    }

    @Override
    @NotNull
    public AnAction createGoToChangeAction(@NotNull Consumer<Integer> onSelected) {
        return new ChangeGoToChangePopupAction<ChangeDiffRequestChain>(this, onSelected){

            @Override
            protected int findSelectedStep(@Nullable Change change) {
                if (change == null) {
                    return -1;
                }
                for (int i = 0; i < ChangeDiffRequestChain.this.myRequests.size(); ++i) {
                    Change c = ((ChangeDiffRequestProducer)ChangeDiffRequestChain.this.myRequests.get(i)).getChange();
                    if (!c.equals((Object)change)) continue;
                    return i;
                }
                return -1;
            }

            @Override
            @NotNull
            protected List<Change> getChanges() {
                return ContainerUtil.mapNotNull(((ChangeDiffRequestChain)this.myChain).getRequests(), (Function)new Function<ChangeDiffRequestProducer, Change>(){

                    public Change fun(ChangeDiffRequestProducer presentable) {
                        return presentable.getChange();
                    }
                });
            }

            @Override
            @Nullable
            protected Change getCurrentSelection() {
                return ((ChangeDiffRequestChain)this.myChain).getRequests().get(((ChangeDiffRequestChain)this.myChain).getIndex()).getChange();
            }
        };
    }
}

