/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeRequestChain;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ShowChangeAbstractAction
extends DumbAwareAction {
    ShowChangeAbstractAction() {
        this.setEnabledInModalContext(true);
    }

    public void update(AnActionEvent e) {
        ChangeRequestChain chain = (ChangeRequestChain)e.getData(VcsDataKeys.DIFF_REQUEST_CHAIN);
        e.getPresentation().setEnabled(chain != null && this.isEnabled(chain));
    }

    protected abstract boolean isEnabled(@NotNull ChangeRequestChain var1);

    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        ChangeRequestChain chain = (ChangeRequestChain)e.getData(VcsDataKeys.DIFF_REQUEST_CHAIN);
        if (project2 == null || chain == null || !this.isEnabled(chain)) {
            return;
        }
        DiffViewer diffViewer = (DiffViewer)e.getData(PlatformDataKeys.COMPOSITE_DIFF_VIEWER);
        if (diffViewer == null) {
            diffViewer = (DiffViewer)e.getData(PlatformDataKeys.DIFF_VIEWER);
        }
        if (diffViewer == null) {
            return;
        }
        this.actionPerformed(e, project2, chain, diffViewer);
    }

    protected void openRequest(@NotNull DiffViewer diffViewer, @Nullable DiffRequest request) {
        if (request != null) {
            if (diffViewer.acceptsType(request.getType())) {
                diffViewer.setDiffRequest(request);
            } else {
                Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                if (window != null) {
                    window.setVisible(false);
                }
                DiffManager.getInstance().getDiffTool().show(request);
            }
        }
    }

    protected abstract void actionPerformed(@NotNull AnActionEvent var1, @NotNull Project var2, @NotNull ChangeRequestChain var3, @NotNull DiffViewer var4);
}

