/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScheduleForAdditionAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        boolean enabled = this.thereAreUnversionedFiles(e);
        e.getPresentation().setEnabled(enabled);
        String place = e.getPlace();
        if ("ActionPlace.VcsQuickListPopupAction".equals(place) || "ChangesViewPopup".equals(place)) {
            e.getPresentation().setVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        List<VirtualFile> unversionedFiles = this.getUnversionedFiles(e);
        if (unversionedFiles.isEmpty()) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl((Project)e.getData(CommonDataKeys.PROJECT));
        changeListManager.addUnversionedFiles(changeListManager.getDefaultChangeList(), unversionedFiles, new Condition<FileStatus>(){

            public boolean value(FileStatus status) {
                return ScheduleForAdditionAction.this.isStatusForAddition(status);
            }
        });
    }

    private boolean thereAreUnversionedFiles(AnActionEvent e) {
        List<VirtualFile> unversionedFiles = ScheduleForAdditionAction.getFromChangesView(e);
        if (unversionedFiles != null && !unversionedFiles.isEmpty()) {
            return true;
        }
        VirtualFile[] files = ScheduleForAdditionAction.getFromSelection(e);
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (files == null || project2 == null) {
            return false;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project2);
        for (VirtualFile file2 : files) {
            if (!this.isFileUnversioned(file2, vcsManager, fileStatusManager)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private List<VirtualFile> getUnversionedFiles(AnActionEvent e) {
        List<VirtualFile> unversionedFiles = ScheduleForAdditionAction.getFromChangesView(e);
        if (unversionedFiles != null && !unversionedFiles.isEmpty()) {
            return unversionedFiles;
        }
        VirtualFile[] files = ScheduleForAdditionAction.getFromSelection(e);
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (files == null || project2 == null) {
            return Collections.emptyList();
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project2);
        unversionedFiles = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : files) {
            if (!this.isFileUnversioned(file2, vcsManager, fileStatusManager)) continue;
            unversionedFiles.add(file2);
        }
        return unversionedFiles;
    }

    private boolean isFileUnversioned(@NotNull VirtualFile file2, @NotNull ProjectLevelVcsManager vcsManager, @NotNull FileStatusManager fileStatusManager) {
        AbstractVcs vcs = vcsManager.getVcsFor(file2);
        return vcs != null && !vcs.areDirectoriesVersionedItems() && file2.isDirectory() || this.isStatusForAddition(fileStatusManager.getStatus(file2));
    }

    protected boolean isStatusForAddition(FileStatus status) {
        return status == FileStatus.UNKNOWN;
    }

    @Nullable
    private static List<VirtualFile> getFromChangesView(AnActionEvent e) {
        return (List)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY);
    }

    @Nullable
    private static VirtualFile[] getFromSelection(AnActionEvent e) {
        return (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
    }
}

