/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsDirtyScopeManagerProxy
extends VcsDirtyScopeManager {
    private boolean myEverythingDirty = false;
    private final Set<VirtualFile> myVFiles = new HashSet<VirtualFile>();
    private final Set<VirtualFile> myVDirs = new HashSet<VirtualFile>();
    private final Set<FilePath> myFiles = new HashSet<FilePath>();
    private final Set<FilePath> myDirs = new HashSet<FilePath>();

    VcsDirtyScopeManagerProxy() {
    }

    public void markEverythingDirty() {
        this.myEverythingDirty = true;
        this.myVDirs.clear();
        this.myVFiles.clear();
        this.myDirs.clear();
        this.myFiles.clear();
    }

    public void fileDirty(@NotNull VirtualFile file2) {
        this.myVFiles.add(file2);
    }

    public void fileDirty(@NotNull FilePath file2) {
        this.myFiles.add(file2);
    }

    public void dirDirtyRecursively(VirtualFile dir, boolean scheduleUpdate) {
        this.myVDirs.add(dir);
    }

    public void dirDirtyRecursively(VirtualFile dir) {
        this.myVDirs.add(dir);
    }

    public void dirDirtyRecursively(FilePath path) {
        this.myDirs.add(path);
    }

    public VcsInvalidated retrieveScopes() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Collection<FilePath> whatFilesDirty(@NotNull Collection<FilePath> files) {
        throw new UnsupportedOperationException();
    }

    public void filePathsDirty(@Nullable Collection<FilePath> filesDirty, @Nullable Collection<FilePath> dirsRecursivelyDirty) {
        if (filesDirty != null) {
            this.myFiles.addAll(filesDirty);
        }
        if (dirsRecursivelyDirty != null) {
            this.myDirs.addAll(dirsRecursivelyDirty);
        }
    }

    public void filesDirty(@Nullable Collection<VirtualFile> filesDirty, @Nullable Collection<VirtualFile> dirsRecursivelyDirty) {
        if (filesDirty != null) {
            this.myVFiles.addAll(filesDirty);
        }
        if (dirsRecursivelyDirty != null) {
            this.myVDirs.addAll(dirsRecursivelyDirty);
        }
    }

    public void callRealManager(VcsDirtyScopeManager manager) {
        if (this.myEverythingDirty) {
            manager.markEverythingDirty();
            return;
        }
        for (FilePath filePath : this.myFiles) {
            manager.fileDirty(filePath);
        }
        for (VirtualFile virtualFile : this.myVFiles) {
            manager.fileDirty(virtualFile);
        }
        for (FilePath filePath : this.myDirs) {
            manager.dirDirtyRecursively(filePath);
        }
        for (VirtualFile virtualFile : this.myVDirs) {
            manager.dirDirtyRecursively(virtualFile);
        }
    }

    public void changesProcessed() {
        throw new UnsupportedOperationException();
    }
}

