/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BeforeAfter;
import java.util.List;

public class FragmentedContent {
    private final Document myBefore;
    private final Document myAfter;
    private final List<BeforeAfter<TextRange>> myRanges;
    private final boolean myOneSide;
    private final boolean myIsAddition;
    private final VirtualFile myFileBefore;
    private final VirtualFile myFileAfter;
    private final FileType myFileTypeBefore;
    private final FileType myFileTypeAfter;

    public FragmentedContent(Document before, Document after2, List<BeforeAfter<TextRange>> ranges, Change change) {
        this.myBefore = before;
        this.myAfter = after2;
        this.myRanges = ranges;
        FileStatus fs = change.getFileStatus();
        this.myIsAddition = FileStatus.ADDED.equals(fs);
        boolean bl = this.myOneSide = FileStatus.ADDED.equals(fs) || FileStatus.DELETED.equals(fs);
        if (change.getBeforeRevision() != null) {
            this.myFileBefore = change.getBeforeRevision().getFile().getVirtualFile();
            this.myFileTypeBefore = change.getBeforeRevision().getFile().getFileType();
        } else {
            this.myFileBefore = null;
            this.myFileTypeBefore = null;
        }
        if (change.getAfterRevision() != null) {
            this.myFileAfter = change.getAfterRevision().getFile().getVirtualFile();
            this.myFileTypeAfter = change.getAfterRevision().getFile().getFileType();
        } else {
            this.myFileAfter = null;
            this.myFileTypeAfter = null;
        }
    }

    public Document getBefore() {
        return this.myBefore;
    }

    public Document getAfter() {
        return this.myAfter;
    }

    public List<BeforeAfter<TextRange>> getRanges() {
        return this.myRanges;
    }

    public int getSize() {
        return this.myRanges.size();
    }

    public boolean isOneSide() {
        return this.myOneSide;
    }

    public boolean isAddition() {
        return this.myIsAddition;
    }

    public VirtualFile getFileBefore() {
        return this.myFileBefore;
    }

    public VirtualFile getFileAfter() {
        return this.myFileAfter;
    }

    public FileType getFileTypeBefore() {
        return this.myFileTypeBefore;
    }

    public FileType getFileTypeAfter() {
        return this.myFileTypeAfter;
    }
}

