/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ShortDiffDetails;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class FileAndDocumentListenersForShortDiff {
    private final ShortDiffDetails myDiffDetails;
    private final MyFileListener myFileListener;
    private final MyDocumentListener myDocumentListener;

    protected FileAndDocumentListenersForShortDiff(ShortDiffDetails diffDetails) {
        this.myDiffDetails = diffDetails;
        this.myFileListener = new MyFileListener();
        this.myDocumentListener = new MyDocumentListener();
    }

    public void on() {
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myFileListener);
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)this.myDocumentListener);
    }

    public void off() {
        VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myFileListener);
        EditorFactory.getInstance().getEventMulticaster().removeDocumentListener((DocumentListener)this.myDocumentListener);
    }

    protected abstract void updateDetails();

    protected abstract boolean updateSynchronously();

    private void impl(VirtualFile vf) {
        boolean wasInCache = this.myDiffDetails.refreshData(vf);
        FilePath filePath = this.myDiffDetails.getCurrentFilePath();
        if (wasInCache || filePath != null && filePath.getVirtualFile() != null && filePath.getVirtualFile().equals(vf)) {
            this.updateDetails();
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private final FileDocumentManager myFileDocumentManager = FileDocumentManager.getInstance();

        public void beforeDocumentChange(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            final VirtualFile vf = this.myFileDocumentManager.getFile(event.getDocument());
            if (vf != null) {
                FilePath filePath = FileAndDocumentListenersForShortDiff.this.myDiffDetails.getCurrentFilePath();
                if (filePath != null && filePath.getVirtualFile() != null && filePath.getVirtualFile().equals(vf)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!FileAndDocumentListenersForShortDiff.this.updateSynchronously()) {
                                FileAndDocumentListenersForShortDiff.this.impl(vf);
                            }
                        }
                    });
                } else {
                    FileAndDocumentListenersForShortDiff.this.impl(vf);
                }
            }
        }
    }

    private class MyFileListener
    extends VirtualFileAdapter {
        private MyFileListener() {
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            FileAndDocumentListenersForShortDiff.this.impl(event.getFile());
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            FileAndDocumentListenersForShortDiff.this.impl(event.getFile());
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            FileAndDocumentListenersForShortDiff.this.impl(event.getFile());
        }
    }
}

