/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.FictiveBackgroundable;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.Waiter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CallbackData {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.openapi.vcs.changes.CallbackData");
    private final Runnable myCallback;
    private final Runnable myWrapperStarter;

    CallbackData(@NotNull Runnable callback, @Nullable Runnable wrapperStarter) {
        this.myCallback = callback;
        this.myWrapperStarter = wrapperStarter;
    }

    public Runnable getCallback() {
        return this.myCallback;
    }

    public Runnable getWrapperStarter() {
        return this.myWrapperStarter;
    }

    public static CallbackData create(final @NotNull Runnable afterUpdate, String title, ModalityState state, final InvokeAfterUpdateMode mode, final @NotNull Project project2) {
        if (mode.isSilently()) {
            return new CallbackData(new Runnable(){

                @Override
                public void run() {
                    if (mode.isCallbackOnAwt()) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LOG.debug("invokeAfterUpdate: silent wrapper called for project: " + project2.getName());
                                if (project2.isDisposed()) {
                                    return;
                                }
                                afterUpdate.run();
                            }
                        });
                    } else {
                        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                            @Override
                            public void run() {
                                if (!project2.isDisposed()) {
                                    afterUpdate.run();
                                }
                            }
                        });
                    }
                }
            }, null);
        }
        if (mode.isSynchronous()) {
            final Waiter waiter = new Waiter(project2, afterUpdate, state, VcsBundle.message((String)"change.list.manager.wait.lists.synchronization", (Object[])new Object[]{title}), mode.isCancellable());
            return new CallbackData(new Runnable(){

                @Override
                public void run() {
                    LOG.debug("invokeAfterUpdate: NOT silent SYNCHRONOUS wrapper called for project: " + project2.getName());
                    waiter.done();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    ProgressManager.getInstance().run((Task)waiter);
                }
            });
        }
        final FictiveBackgroundable fictiveBackgroundable = new FictiveBackgroundable(project2, afterUpdate, mode.isCancellable(), title, state);
        return new CallbackData(new Runnable(){

            @Override
            public void run() {
                LOG.debug("invokeAfterUpdate: NOT silent wrapper called for project: " + project2.getName());
                fictiveBackgroundable.done();
            }
        }, new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().run((Task)fictiveBackgroundable);
            }
        });
    }
}

