/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.Details;
import com.intellij.openapi.vcs.GenericDetailsLoader;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.DetailsPanel;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.Ticket;
import com.intellij.util.continuation.ModalityIgnorantBackgroundableTask;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRefreshablePanel<T>
implements RefreshablePanel<Change> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.AbstractRefreshablePanel");
    protected final Ticket myTicket;
    private final DetailsPanel myDetailsPanel;
    private final GenericDetailsLoader<Ticket, T> myDetailsLoader;
    private final BackgroundTaskQueue myQueue;
    private volatile boolean myDisposed;

    protected AbstractRefreshablePanel(final Project project2, final String loadingTitle, BackgroundTaskQueue queue) {
        this.myQueue = queue;
        this.myTicket = new Ticket();
        this.myDetailsPanel = new DetailsPanel();
        this.myDetailsPanel.loading();
        this.myDetailsPanel.layout();
        this.myDetailsLoader = new GenericDetailsLoader((Consumer)new Consumer<Ticket>(){

            public void consume(Ticket ticket) {
                Loader loader = new Loader(project2, loadingTitle, AbstractRefreshablePanel.this.myTicket.copy());
                loader.runSteadily(new Consumer<Task.Backgroundable>(){

                    public void consume(Task.Backgroundable backgroundable) {
                        AbstractRefreshablePanel.this.myQueue.run(backgroundable);
                    }
                });
            }
        }, new PairConsumer<Ticket, T>(){

            public void consume(Ticket ticket, T t) {
                AbstractRefreshablePanel.this.acceptData(t);
            }
        });
    }

    @Override
    public boolean refreshDataSynch() {
        return false;
    }

    @Override
    public void dataChanged() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myTicket.increment();
    }

    @Override
    public void refresh() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!Comparing.equal((Object)this.myDetailsLoader.getCurrentlySelected(), (Object)this.myTicket)) {
            Ticket copy = this.myTicket.copy();
            this.myDetailsLoader.updateSelection((Object)copy, false);
            this.myDetailsPanel.loading();
            this.myDetailsPanel.layout();
        } else {
            this.refreshPresentation();
        }
    }

    protected abstract void refreshPresentation();

    protected abstract T loadImpl() throws VcsException;

    protected abstract JPanel dataToPresentation(T var1);

    protected abstract void disposeImpl();

    private void acceptData(T t) {
        JPanel panel = this.dataToPresentation(t);
        this.myDetailsPanel.data(panel);
        this.myDetailsPanel.layout();
    }

    @Override
    public JPanel getPanel() {
        return this.myDetailsPanel.getPanel();
    }

    @Override
    public boolean isStillValid(Change data) {
        return true;
    }

    public void dispose() {
        this.myDisposed = true;
        this.disposeImpl();
    }

    private static class MyRuntime
    extends RuntimeException {
        private MyRuntime(Throwable cause) {
            super(cause);
        }
    }

    private class Loader
    extends ModalityIgnorantBackgroundableTask {
        private final Ticket myTicketCopy;
        private T myT;

        private Loader(@NotNull Project project2, String title, Ticket ticketCopy) {
            super(project2, title, false);
            this.myTicketCopy = ticketCopy;
        }

        @Override
        protected void doInAwtIfFail(Exception e) {
            Exception cause = e instanceof MyRuntime && e.getCause() != null ? (Exception)e.getCause() : e;
            LOG.info((Throwable)e);
            String message = cause.getMessage() == null ? e.getMessage() : cause.getMessage();
            message = message == null ? "Unknown error" : message;
            VcsBalloonProblemNotifier.showOverChangesView(this.myProject, message, MessageType.ERROR, new NamedRunnable[0]);
        }

        @Override
        protected void doInAwtIfCancel() {
        }

        @Override
        protected void doInAwtIfSuccess() {
            if (AbstractRefreshablePanel.this.myDisposed) {
                return;
            }
            try {
                AbstractRefreshablePanel.this.myDetailsLoader.take((Object)this.myTicketCopy, this.myT);
            }
            catch (Details.AlreadyDisposedException alreadyDisposedException) {
                // empty catch block
            }
        }

        @Override
        protected void runImpl(@NotNull ProgressIndicator indicator) {
            if (AbstractRefreshablePanel.this.myDisposed) {
                return;
            }
            try {
                this.myT = AbstractRefreshablePanel.this.loadImpl();
            }
            catch (VcsException e) {
                throw new MyRuntime(e);
            }
        }
    }
}

