/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import org.jetbrains.annotations.NotNull;

public class VFSForAnnotationListener
extends VirtualFileAdapter {
    private final VirtualFile myFile;
    private final FileAnnotation myFileAnnotation;

    public VFSForAnnotationListener(VirtualFile file2, FileAnnotation fileAnnotation) {
        this.myFileAnnotation = fileAnnotation;
        this.myFile = file2;
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (!Comparing.equal((Object)this.myFile, (Object)event.getFile())) {
            return;
        }
        if (!event.isFromRefresh()) {
            return;
        }
        if ("writable".equals(event.getPropertyName()) && ((Boolean)event.getOldValue()).booleanValue()) {
            this.myFileAnnotation.close();
        }
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (!Comparing.equal((Object)this.myFile, (Object)event.getFile())) {
            return;
        }
        if (!event.isFromRefresh()) {
            return;
        }
        if (!this.myFile.isWritable()) {
            this.myFileAnnotation.close();
        }
    }
}

