/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.actions.CachedVcsContext;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsContextWrapper
implements VcsContext {
    protected final DataContext myContext;
    protected final int myModifiers;
    private final String myPlace;
    private final String myActionName;

    public VcsContextWrapper(DataContext context, int modifiers, String place, String actionName) {
        this.myContext = context;
        this.myModifiers = modifiers;
        this.myPlace = place;
        this.myActionName = actionName;
    }

    public String getPlace() {
        return this.myPlace;
    }

    public String getActionName() {
        return this.myActionName;
    }

    @NotNull
    public static VcsContext createCachedInstanceOn(@NotNull AnActionEvent event) {
        return new CachedVcsContext(VcsContextWrapper.createInstanceOn(event));
    }

    @NotNull
    public static VcsContextWrapper createInstanceOn(@NotNull AnActionEvent event) {
        return new VcsContextWrapper(event.getDataContext(), event.getModifiers(), event.getPlace(), event.getPresentation().getText());
    }

    public Project getProject() {
        return (Project)CommonDataKeys.PROJECT.getData(this.myContext);
    }

    public VirtualFile getSelectedFile() {
        VirtualFile[] files = this.getSelectedFiles();
        return files.length == 0 ? null : files[0];
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        VirtualFile[] fileArray = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(this.myContext);
        if (fileArray != null) {
            return VcsContextWrapper.filterLocalFiles(fileArray);
        }
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(this.myContext);
        if (virtualFile != null && VcsContextWrapper.isLocal(virtualFile)) {
            return new VirtualFile[]{virtualFile};
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    private static boolean isLocal(VirtualFile virtualFile) {
        return virtualFile.isInLocalFileSystem();
    }

    private static VirtualFile[] filterLocalFiles(VirtualFile[] fileArray) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : fileArray) {
            if (!VcsContextWrapper.isLocal(virtualFile)) continue;
            result.add(virtualFile);
        }
        return VfsUtilCore.toVirtualFileArray(result);
    }

    public Editor getEditor() {
        return (Editor)CommonDataKeys.EDITOR.getData(this.myContext);
    }

    public Collection<VirtualFile> getSelectedFilesCollection() {
        return Arrays.asList(this.getSelectedFiles());
    }

    public File getSelectedIOFile() {
        File file2 = (File)VcsDataKeys.IO_FILE.getData(this.myContext);
        if (file2 != null) {
            return file2;
        }
        File[] files = (File[])VcsDataKeys.IO_FILE_ARRAY.getData(this.myContext);
        if (files == null) {
            return null;
        }
        if (files.length == 0) {
            return null;
        }
        return files[0];
    }

    public File[] getSelectedIOFiles() {
        File[] files = (File[])VcsDataKeys.IO_FILE_ARRAY.getData(this.myContext);
        if (files != null && files.length > 0) {
            return files;
        }
        File file2 = this.getSelectedIOFile();
        if (file2 != null) {
            return new File[]{file2};
        }
        return null;
    }

    public int getModifiers() {
        return this.myModifiers;
    }

    public Refreshable getRefreshableDialog() {
        return (Refreshable)Refreshable.PANEL_KEY.getData(this.myContext);
    }

    @NotNull
    public FilePath[] getSelectedFilePaths() {
        VirtualFile[] selectedFiles;
        FilePath[] paths;
        THashSet result = new THashSet();
        FilePath path = (FilePath)VcsDataKeys.FILE_PATH.getData(this.myContext);
        if (path != null) {
            result.add(path);
        }
        if ((paths = (FilePath[])VcsDataKeys.FILE_PATH_ARRAY.getData(this.myContext)) != null) {
            for (FilePath filePath : paths) {
                if (result.contains(filePath)) continue;
                result.add(filePath);
            }
        }
        for (VirtualFile selectedFile : selectedFiles = this.getSelectedFiles()) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)selectedFile);
            result.add(filePath);
        }
        File[] selectedIOFiles = this.getSelectedIOFiles();
        if (selectedIOFiles != null) {
            for (File selectedFile : selectedIOFiles) {
                FilePath filePath = VcsUtil.getFilePath((File)selectedFile);
                if (filePath == null) continue;
                result.add(filePath);
            }
        }
        return result.toArray(new FilePath[result.size()]);
    }

    @Nullable
    public FilePath getSelectedFilePath() {
        FilePath[] selectedFilePaths = this.getSelectedFilePaths();
        if (selectedFilePaths.length == 0) {
            return null;
        }
        return selectedFilePaths[0];
    }

    @Nullable
    public ChangeList[] getSelectedChangeLists() {
        return (ChangeList[])VcsDataKeys.CHANGE_LISTS.getData(this.myContext);
    }

    @Nullable
    public Change[] getSelectedChanges() {
        return (Change[])VcsDataKeys.CHANGES.getData(this.myContext);
    }
}

