/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.actions.ShortNameType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowShortenNames
extends ActionGroup {
    private final AnAction[] myChildren;

    public ShowShortenNames(EditorGutterComponentEx gutter) {
        super("Names", true);
        ArrayList<SetShortNameTypeAction> kids = new ArrayList<SetShortNameTypeAction>(ShortNameType.values().length);
        for (ShortNameType type : ShortNameType.values()) {
            kids.add(new SetShortNameTypeAction(type, gutter));
        }
        this.myChildren = kids.toArray(new AnAction[kids.size()]);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        return this.myChildren;
    }

    public static boolean isSet() {
        return ShowShortenNames.getType() != ShortNameType.NONE;
    }

    public static ShortNameType getType() {
        for (ShortNameType type : ShortNameType.values()) {
            if (!type.isSet()) continue;
            return type;
        }
        return ShortNameType.LASTNAME;
    }

    public static class SetShortNameTypeAction
    extends ToggleAction
    implements DumbAware {
        private final ShortNameType myType;
        private final EditorGutterComponentEx myGutter;

        public SetShortNameTypeAction(ShortNameType type, EditorGutterComponentEx gutter) {
            super(type.getDescription());
            this.myType = type;
            this.myGutter = gutter;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myType == ShowShortenNames.getType();
        }

        public void setSelected(AnActionEvent e, boolean enabled) {
            if (enabled) {
                this.myType.set();
            }
            this.myGutter.revalidateMarkup();
        }
    }
}

