/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.actions.ColorMode;
import com.intellij.openapi.vcs.actions.ShortNameType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowAnnotationColorsAction
extends ActionGroup {
    private final AnAction[] myChildren;

    public ShowAnnotationColorsAction(EditorGutterComponentEx gutter) {
        super("Colors", true);
        ArrayList<SetColorModeAction> kids = new ArrayList<SetColorModeAction>(ShortNameType.values().length);
        for (ColorMode type : ColorMode.values()) {
            kids.add(new SetColorModeAction(type, gutter));
        }
        this.myChildren = kids.toArray(new AnAction[kids.size()]);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        return this.myChildren;
    }

    public static ColorMode getType() {
        for (ColorMode type : ColorMode.values()) {
            if (!type.isSet()) continue;
            return type;
        }
        return ColorMode.ORDER;
    }

    public static class SetColorModeAction
    extends ToggleAction
    implements DumbAware {
        private final ColorMode myType;
        private final EditorGutterComponentEx myGutter;

        public SetColorModeAction(ColorMode type, EditorGutterComponentEx gutter) {
            super(type.getDescription());
            this.myType = type;
            this.myGutter = gutter;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myType == ShowAnnotationColorsAction.getType();
        }

        public void setSelected(AnActionEvent e, boolean enabled) {
            if (enabled) {
                this.myType.set();
            }
            this.myGutter.revalidateMarkup();
        }
    }
}

