/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistoryProviderBackgroundableProxy;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.impl.CachedRevisionsContents;
import com.intellij.openapi.vcs.history.impl.VcsSelectionHistoryDialog;
import com.intellij.openapi.vcs.impl.BackgroundableActionEnabledHandler;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsSelection;
import com.intellij.vcsUtil.VcsSelectionUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SelectedBlockHistoryAction
extends AbstractVcsAction {
    protected boolean isEnabled(VcsContext context) {
        VirtualFile[] selectedFiles = context.getSelectedFiles();
        if (selectedFiles == null) {
            return false;
        }
        if (selectedFiles.length == 0) {
            return false;
        }
        VirtualFile file2 = selectedFiles[0];
        Project project2 = context.getProject();
        if (project2 == null) {
            return false;
        }
        ProjectLevelVcsManagerImpl vcsManager = (ProjectLevelVcsManagerImpl)ProjectLevelVcsManager.getInstance((Project)project2);
        BackgroundableActionEnabledHandler handler2 = vcsManager.getBackgroundableActionHandler(VcsBackgroundableActions.HISTORY_FOR_SELECTION);
        if (handler2.isInProgress(VcsBackgroundableActions.keyFrom(file2))) {
            return false;
        }
        AbstractVcs vcs = vcsManager.getVcsFor(file2);
        if (vcs == null) {
            return false;
        }
        VcsHistoryProvider vcsHistoryProvider = vcs.getVcsBlockHistoryProvider();
        if (vcsHistoryProvider == null) {
            return false;
        }
        if (!AbstractVcs.fileInVcsByFileStatus((Project)project2, (FilePath)VcsUtil.getFilePath((VirtualFile)file2))) {
            return false;
        }
        VcsSelection selection = VcsSelectionUtil.getSelection((VcsContext)context);
        return selection != null;
    }

    @Override
    public void actionPerformed(final @NotNull VcsContext context) {
        try {
            final VcsSelection selection = VcsSelectionUtil.getSelection((VcsContext)context);
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(selection.getDocument());
            final Project project2 = context.getProject();
            if (project2 == null) {
                return;
            }
            final AbstractVcs activeVcs = ProjectLevelVcsManager.getInstance((Project)project2).getVcsFor(file2);
            if (activeVcs == null) {
                return;
            }
            final VcsHistoryProvider provider = activeVcs.getVcsBlockHistoryProvider();
            final int selectionStart = selection.getSelectionStartLineNumber();
            final int selectionEnd = selection.getSelectionEndLineNumber();
            final VcsException[] preloadException = new VcsException[1];
            final CachedRevisionsContents cachedRevisionsContents = new CachedRevisionsContents(project2, file2);
            new VcsHistoryProviderBackgroundableProxy(activeVcs, provider, activeVcs.getDiffProvider()).createSessionFor(activeVcs.getKeyInstanceMethod(), VcsUtil.getFilePath((VirtualFile)file2), new Consumer<VcsHistorySession>(){

                public void consume(VcsHistorySession session) {
                    if (preloadException[0] != null) {
                        SelectedBlockHistoryAction.reportError((Exception)((Object)preloadException[0]));
                    }
                    if (session == null) {
                        return;
                    }
                    VcsSelectionHistoryDialog vcsHistoryDialog = new VcsSelectionHistoryDialog(project2, context.getSelectedFiles()[0], context.getEditor(), provider, session, activeVcs, Math.min(selectionStart, selectionEnd), Math.max(selectionStart, selectionEnd), selection.getDialogTitle(), cachedRevisionsContents);
                    vcsHistoryDialog.show();
                }
            }, VcsBackgroundableActions.HISTORY_FOR_SELECTION, false, new Consumer<VcsHistorySession>(){

                public void consume(VcsHistorySession vcsHistorySession) {
                    if (vcsHistorySession == null) {
                        return;
                    }
                    List revisionList = vcsHistorySession.getRevisionList();
                    cachedRevisionsContents.setRevisions(revisionList);
                    if (VcsConfiguration.getInstance((Project)project2).SHOW_ONLY_CHANGED_IN_SELECTION_DIFF) {
                        try {
                            cachedRevisionsContents.loadContentsFor(revisionList.toArray(new VcsFileRevision[revisionList.size()]));
                        }
                        catch (VcsException e) {
                            preloadException[0] = e;
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            SelectedBlockHistoryAction.reportError(exception);
        }
    }

    @Override
    protected void update(VcsContext context, Presentation presentation) {
        presentation.setEnabled(this.isEnabled(context));
        VcsSelection selection = VcsSelectionUtil.getSelection((VcsContext)context);
        if (selection != null) {
            presentation.setText(selection.getActionName());
        }
    }

    protected boolean forceSyncUpdate(AnActionEvent e) {
        return true;
    }

    protected static void reportError(Exception exception) {
        Messages.showMessageDialog((String)exception.getLocalizedMessage(), (String)VcsBundle.message((String)"message.title.could.not.load.file.history", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
    }
}

