/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractCommonCheckinAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CommonCheckinProjectAction
extends AbstractCommonCheckinAction {
    @Override
    @NotNull
    protected FilePath[] getRoots(@NotNull VcsContext context) {
        Project project2 = context.getProject();
        ArrayList<FilePath> virtualFiles = new ArrayList<FilePath>();
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        for (AbstractVcs vcs : vcsManager.getAllActiveVcss()) {
            VirtualFile[] roots;
            if (vcs.getCheckinEnvironment() == null) continue;
            for (VirtualFile root : roots = vcsManager.getRootsUnderVcs(vcs)) {
                virtualFiles.add(VcsUtil.getFilePath((VirtualFile)root));
            }
        }
        return virtualFiles.toArray(new FilePath[virtualFiles.size()]);
    }

    @Override
    protected boolean approximatelyHasRoots(VcsContext dataContext) {
        Project project2 = dataContext.getProject();
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        return vcsManager.hasAnyMappings();
    }

    @Override
    protected void update(VcsContext vcsContext, Presentation presentation) {
        Project project2 = vcsContext.getProject();
        if (project2 == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        if (!plVcsManager.hasActiveVcss()) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        String actionName = this.getActionName(vcsContext) + "...";
        presentation.setText(actionName);
        presentation.setEnabled(!plVcsManager.isBackgroundVcsOperationRunning());
        presentation.setVisible(true);
    }

    @Override
    protected String getActionName(@NotNull VcsContext dataContext) {
        return VcsBundle.message((String)"action.name.commit.project", (Object[])new Object[0]);
    }

    @Override
    protected String getMnemonicsFreeActionName(VcsContext context) {
        return VcsBundle.message((String)"vcs.command.name.checkin.no.mnemonics", (Object[])new Object[0]);
    }

    @Override
    protected boolean filterRootsBeforeAction() {
        return false;
    }
}

