/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.AnnotateRevisionActionBase;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.UpToDateLineNumberListener;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AnnotateRevisionAction
extends AnnotateRevisionActionBase
implements DumbAware,
UpToDateLineNumberListener {
    @NotNull
    private final FileAnnotation myAnnotation;
    @NotNull
    private final AbstractVcs myVcs;
    private int currentLine;

    public AnnotateRevisionAction(@Nullable String text, @Nullable String description, @Nullable Icon icon, @NotNull FileAnnotation annotation, @NotNull AbstractVcs vcs) {
        super(text, description, icon);
        this.myAnnotation = annotation;
        this.myVcs = vcs;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (Boolean.TRUE.equals(e.getData(PlatformDataKeys.IS_MODAL_CONTEXT))) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (this.myAnnotation.getFile() == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (this.getRevisions() == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        super.update(e);
    }

    @Nullable
    protected abstract List<VcsFileRevision> getRevisions();

    @Override
    @Nullable
    protected AbstractVcs getVcs(@NotNull AnActionEvent e) {
        return this.myVcs;
    }

    @Override
    @Nullable
    protected VirtualFile getFile(@NotNull AnActionEvent e) {
        VcsFileRevision revision = this.getFileRevision(e);
        if (revision == null) {
            return null;
        }
        final FileType currentFileType = this.myAnnotation.getFile().getFileType();
        FilePath filePath = revision instanceof VcsFileRevisionEx ? ((VcsFileRevisionEx)revision).getPath() : VcsUtil.getFilePath((VirtualFile)this.myAnnotation.getFile());
        return new VcsVirtualFile(filePath.getPath(), revision, (VirtualFileSystem)VcsFileSystem.getInstance()){

            @NotNull
            public FileType getFileType() {
                FileType type = super.getFileType();
                if (!type.isBinary()) {
                    return type;
                }
                if (!currentFileType.isBinary()) {
                    return currentFileType;
                }
                return PlainTextFileType.INSTANCE;
            }
        };
    }

    @Override
    @Nullable
    protected VcsFileRevision getFileRevision(@NotNull AnActionEvent e) {
        List<VcsFileRevision> revisions = this.getRevisions();
        assert (revisions != null);
        if (this.currentLine < 0 || this.currentLine >= revisions.size()) {
            return null;
        }
        return revisions.get(this.currentLine);
    }

    public void consume(Integer integer) {
        this.currentLine = integer;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }
}

