/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CheckRemoteStatusCheckinHandlerFactory
extends CheckinHandlerFactory {
    @NotNull
    public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
        return new MyCheckinHandler(panel);
    }

    private static class MyCheckinHandler
    extends CheckinHandler {
        private final CheckinProjectPanel myPanel;
        private final VcsConfiguration myVcsConfiguration;

        private MyCheckinHandler(CheckinProjectPanel panel) {
            this.myPanel = panel;
            this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myPanel.getProject());
        }

        public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
            final JCheckBox checkUpToDate = new JCheckBox(VcsBundle.message((String)"checkbox.checkin.options.check.files.up.to.date", (Object[])new Object[0]));
            return new RefreshableOnComponent(){

                public JComponent getComponent() {
                    JPanel panel = new JPanel(new BorderLayout());
                    panel.add((Component)checkUpToDate, "West");
                    return panel;
                }

                public void refresh() {
                }

                public void saveState() {
                    ((MyCheckinHandler)this).myVcsConfiguration.CHECK_FILES_UP_TO_DATE_BEFORE_COMMIT = checkUpToDate.isSelected();
                }

                public void restoreState() {
                    checkUpToDate.setSelected(((MyCheckinHandler)this).myVcsConfiguration.CHECK_FILES_UP_TO_DATE_BEFORE_COMMIT);
                }
            };
        }

        public void includedChangesChanged() {
        }

        private void doCheck() {
            this.myPanel.getFiles();
        }
    }
}

