/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.WindowStateServiceImpl;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

@State(name="WindowStateApplicationService", storages={@Storage(value="window.state.xml", roamingType=RoamingType.DISABLED)})
final class WindowStateApplicationService
extends WindowStateServiceImpl {
    WindowStateApplicationService() {
    }

    @Override
    Point getDefaultLocationFor(Object object, @NotNull String key) {
        return DimensionService.getInstance().getLocation(key);
    }

    @Override
    Dimension getDefaultSizeFor(Object object, @NotNull String key) {
        return DimensionService.getInstance().getSize(key);
    }

    @Override
    Rectangle getDefaultBoundsFor(Object object, @NotNull String key) {
        Point location = this.getDefaultLocationFor(object, key);
        if (location == null) {
            return null;
        }
        Dimension size = this.getDefaultSizeFor(object, key);
        if (size == null) {
            return null;
        }
        return new Rectangle(location, size);
    }

    @Override
    boolean getDefaultMaximizedFor(Object object, @NotNull String key) {
        return 6 == DimensionService.getInstance().getExtendedState(key);
    }
}

