/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.UserUpdateSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.xmlb.annotations.CollectionBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="UpdatesConfigurable", storages={@Storage(value="updates.xml", roamingType=RoamingType.DISABLED), @Storage(value="other.xml", deprecated=true)})
public class UpdateSettings
implements PersistentStateComponent<State>,
UserUpdateSettings {
    private State myState = new State();

    public static UpdateSettings getInstance() {
        return (UpdateSettings)ServiceManager.getService(UpdateSettings.class);
    }

    @NotNull
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
        this.myState.LAST_BUILD_CHECKED = StringUtil.nullize((String)this.myState.LAST_BUILD_CHECKED);
    }

    @Nullable
    public String getLasBuildChecked() {
        return this.myState.LAST_BUILD_CHECKED;
    }

    @NotNull
    public List<String> getStoredPluginHosts() {
        return this.myState.pluginHosts;
    }

    public boolean isCheckNeeded() {
        return this.myState.CHECK_NEEDED;
    }

    public void setCheckNeeded(boolean value) {
        this.myState.CHECK_NEEDED = value;
    }

    public List<String> getEnabledExternalUpdateSources() {
        return this.myState.enabledExternalComponentSources;
    }

    public List<String> getKnownExternalUpdateSources() {
        return this.myState.knownExternalComponentSources;
    }

    public Map<String, String> getExternalUpdateChannels() {
        return this.myState.externalUpdateChannels;
    }

    public boolean isSecureConnection() {
        return this.myState.SECURE_CONNECTION;
    }

    public void setSecureConnection(boolean value) {
        this.myState.SECURE_CONNECTION = value;
    }

    public long getLastTimeChecked() {
        return this.myState.LAST_TIME_CHECKED;
    }

    @Override
    @NotNull
    public List<String> getKnownChannelsIds() {
        return new ArrayList<String>(this.myState.knownUpdateChannels);
    }

    @Override
    public void setKnownChannelIds(@NotNull List<String> ids) {
        this.myState.knownUpdateChannels.clear();
        this.myState.knownUpdateChannels.addAll(ids);
    }

    public void forgetChannelId(String id) {
        this.myState.knownUpdateChannels.remove(id);
    }

    @Override
    public List<String> getIgnoredBuildNumbers() {
        return this.myState.ignoredBuildNumbers;
    }

    @Override
    @NotNull
    public ChannelStatus getSelectedChannelStatus() {
        return ChannelStatus.fromCode(this.myState.UPDATE_CHANNEL_TYPE);
    }

    public void setSelectedChannelStatus(@NotNull ChannelStatus channel) {
        this.myState.UPDATE_CHANNEL_TYPE = channel.getCode();
    }

    public List<String> getPluginHosts() {
        ArrayList<String> hosts = new ArrayList<String>(this.myState.pluginHosts);
        String pluginHosts = System.getProperty("idea.plugin.hosts");
        if (pluginHosts != null) {
            ContainerUtil.addAll(hosts, (Object[])pluginHosts.split(";"));
        }
        return hosts;
    }

    public void forceCheckForUpdateAfterRestart() {
        this.myState.LAST_TIME_CHECKED = 0L;
    }

    public void saveLastCheckedInfo() {
        this.myState.LAST_TIME_CHECKED = System.currentTimeMillis();
        this.myState.LAST_BUILD_CHECKED = ApplicationInfo.getInstance().getBuild().asString();
    }

    public boolean canUseSecureConnection() {
        return this.myState.SECURE_CONNECTION && NetUtils.isSniEnabled();
    }

    public String getUpdateChannelType() {
        return this.myState.UPDATE_CHANNEL_TYPE;
    }

    public void setUpdateChannelType(@NotNull String value) {
        this.myState.UPDATE_CHANNEL_TYPE = value;
    }

    public static class State {
        @CollectionBean
        public final List<String> pluginHosts = new SmartList();
        @CollectionBean
        public final List<String> knownUpdateChannels = new SmartList();
        @CollectionBean
        public final List<String> ignoredBuildNumbers = new SmartList();
        @CollectionBean
        public final List<String> enabledExternalComponentSources = new SmartList();
        @CollectionBean
        public final List<String> knownExternalComponentSources = new SmartList();
        @CollectionBean
        public final Map<String, String> externalUpdateChannels = new HashMap<String, String>();
        public boolean CHECK_NEEDED = true;
        public long LAST_TIME_CHECKED = 0L;
        public String LAST_BUILD_CHECKED;
        public String UPDATE_CHANNEL_TYPE = ChannelStatus.RELEASE.getCode();
        public boolean SECURE_CONNECTION = true;
    }
}

