/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginDownloader {
    private static final Logger LOG = Logger.getInstance((String)("#" + PluginDownloader.class.getName()));
    private static final String FILENAME = "filename=";
    private final String myPluginId;
    private final String myPluginUrl;
    private final String myPluginName;
    private String myPluginVersion;
    private BuildNumber myBuildNumber;
    private File myFile;
    private File myOldFile;
    private String myDescription;
    private List<PluginId> myDepends;
    private IdeaPluginDescriptor myDescriptor;
    private boolean myForceHttps;

    private PluginDownloader(@NotNull String pluginId, @NotNull String pluginUrl, @Nullable String pluginName, @Nullable String pluginVersion, @Nullable BuildNumber buildNumber) {
        this.myPluginId = pluginId;
        this.myPluginUrl = pluginUrl;
        this.myPluginVersion = pluginVersion;
        this.myPluginName = pluginName;
        this.myBuildNumber = buildNumber;
    }

    public String getPluginId() {
        return this.myPluginId;
    }

    public String getPluginVersion() {
        return this.myPluginVersion;
    }

    public String getPluginName() {
        return this.myPluginName != null ? this.myPluginName : this.myPluginId;
    }

    public BuildNumber getBuildNumber() {
        return this.myBuildNumber;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public List<PluginId> getDepends() {
        return this.myDepends;
    }

    public void setDepends(List<PluginId> depends) {
        this.myDepends = depends;
    }

    public IdeaPluginDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    public void setDescriptor(IdeaPluginDescriptor descriptor) {
        this.myDescriptor = descriptor;
    }

    public void setForceHttps(boolean forceHttps) {
        this.myForceHttps = forceHttps;
    }

    public boolean prepareToInstall(@NotNull ProgressIndicator indicator) throws IOException {
        if (this.myFile != null) {
            return true;
        }
        IdeaPluginDescriptor descriptor = null;
        if (!Boolean.getBoolean("StartupWizardMode") && PluginManager.isPluginInstalled(PluginId.getId((String)this.myPluginId))) {
            descriptor = PluginManager.getPlugin(PluginId.getId((String)this.myPluginId));
            LOG.assertTrue(descriptor != null);
            if (this.myPluginVersion != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(descriptor, this.myPluginVersion) <= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                return false;
            }
            this.myOldFile = descriptor.isBundled() ? null : descriptor.getPath();
        }
        String errorMessage = IdeBundle.message((String)"unknown.error", (Object[])new Object[0]);
        try {
            this.myFile = this.downloadPlugin(indicator);
        }
        catch (IOException ex) {
            this.myFile = null;
            LOG.warn((Throwable)ex);
            errorMessage = ex.getMessage();
        }
        if (this.myFile == null) {
            if (ApplicationManager.getApplication() != null) {
                final String text = IdeBundle.message((String)"error.plugin.was.not.installed", (Object[])new Object[]{this.getPluginName(), errorMessage});
                final String title = IdeBundle.message((String)"title.failed.to.download", (Object[])new Object[0]);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)text, (String)title);
                    }
                });
            }
            return false;
        }
        IdeaPluginDescriptorImpl actualDescriptor = PluginDownloader.loadDescriptionFromJar(this.myFile);
        if (actualDescriptor != null) {
            InstalledPluginsState state = InstalledPluginsState.getInstanceIfLoaded();
            if (state != null && state.wasUpdated(actualDescriptor.getPluginId())) {
                return false;
            }
            this.myPluginVersion = actualDescriptor.getVersion();
            if (descriptor != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(descriptor, this.myPluginVersion) <= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                return false;
            }
            this.setDescriptor(actualDescriptor);
            if (PluginManagerCore.isIncompatible(actualDescriptor, this.myBuildNumber)) {
                LOG.info("Plugin " + this.myPluginId + " is incompatible with current installation " + "(since:" + actualDescriptor.getSinceBuild() + " until:" + actualDescriptor.getUntilBuild() + ")");
                return false;
            }
        }
        return true;
    }

    public static int compareVersionsSkipBrokenAndIncompatible(@NotNull IdeaPluginDescriptor existingPlugin, String newPluginVersion) {
        int state = PluginDownloader.comparePluginVersions(newPluginVersion, existingPlugin.getVersion());
        if (state < 0 && (PluginManagerCore.isBrokenPlugin(existingPlugin) || PluginManagerCore.isIncompatible(existingPlugin))) {
            state = 1;
        }
        return state;
    }

    public static int comparePluginVersions(String newPluginVersion, String oldPluginVersion) {
        return VersionComparatorUtil.compare((String)newPluginVersion, (String)oldPluginVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptionFromJar(File file2) throws IOException {
        IdeaPluginDescriptorImpl descriptor = PluginManagerCore.loadDescriptor(file2, "plugin.xml");
        if (descriptor == null && file2.getName().endsWith(".zip")) {
            File outputDir = FileUtil.createTempDirectory((String)"plugin", (String)"");
            try {
                ZipUtil.extract((File)file2, (File)outputDir, null);
                File[] files = outputDir.listFiles();
                if (files != null && files.length == 1) {
                    descriptor = PluginManagerCore.loadDescriptor(files[0], "plugin.xml");
                }
            }
            finally {
                FileUtil.delete((File)outputDir);
            }
        }
        return descriptor;
    }

    public void install() throws IOException {
        LOG.assertTrue(this.myFile != null);
        if (this.myOldFile != null) {
            StartupActionScriptManager.DeleteCommand deleteOld = new StartupActionScriptManager.DeleteCommand(this.myOldFile);
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)deleteOld);
        }
        PluginInstaller.install(this.myFile, this.getPluginName(), true);
        InstalledPluginsState state = InstalledPluginsState.getInstanceIfLoaded();
        if (state != null) {
            state.onPluginInstall(this.myDescriptor);
        }
    }

    @NotNull
    private File downloadPlugin(final @NotNull ProgressIndicator indicator) throws IOException {
        File pluginsTemp = new File(PathManager.getPluginTempPath());
        if (!pluginsTemp.exists() && !pluginsTemp.mkdirs()) {
            throw new IOException(IdeBundle.message((String)"error.cannot.create.temp.dir", (Object[])new Object[]{pluginsTemp}));
        }
        final File file2 = FileUtil.createTempFile((File)pluginsTemp, (String)"plugin_", (String)"_download", (boolean)true, (boolean)false);
        indicator.checkCanceled();
        indicator.setText2(IdeBundle.message((String)"progress.downloading.plugin", (Object[])new Object[]{this.getPluginName()}));
        return (File)HttpRequests.request((String)this.myPluginUrl).gzip(false).forceHttps(this.myForceHttps).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<File>(){

            public File process(@NotNull HttpRequests.Request request) throws IOException {
                request.saveToFile(file2, indicator);
                String fileName = PluginDownloader.this.guessFileName(request.getConnection(), file2);
                File newFile = new File(file2.getParentFile(), fileName);
                FileUtil.rename((File)file2, (File)newFile);
                return newFile;
            }
        });
    }

    @NotNull
    private String guessFileName(@NotNull URLConnection connection, @NotNull File file2) throws IOException {
        String usedURL;
        String fileName = null;
        String contentDisposition = connection.getHeaderField("Content-Disposition");
        LOG.debug("header: " + contentDisposition);
        if (contentDisposition != null && contentDisposition.contains(FILENAME)) {
            int startIdx = contentDisposition.indexOf(FILENAME);
            int endIdx = contentDisposition.indexOf(59, startIdx);
            fileName = contentDisposition.substring(startIdx + FILENAME.length(), endIdx > 0 ? endIdx : contentDisposition.length());
            if (StringUtil.startsWithChar((CharSequence)fileName, (char)'\"') && StringUtil.endsWithChar((CharSequence)fileName, (char)'\"')) {
                fileName = fileName.substring(1, fileName.length() - 1);
            }
        }
        if (fileName == null && ((fileName = (usedURL = connection.getURL().toString()).substring(usedURL.lastIndexOf(47) + 1)).length() == 0 || fileName.contains("?"))) {
            fileName = this.myPluginUrl.substring(this.myPluginUrl.lastIndexOf(47) + 1);
        }
        if (!PathUtil.isValidFileName(fileName)) {
            FileUtil.delete((File)file2);
            throw new IOException("Invalid filename returned by a server");
        }
        return fileName;
    }

    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor) throws IOException {
        return PluginDownloader.createDownloader(descriptor, null, null);
    }

    @NotNull
    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor, @Nullable String host, @Nullable BuildNumber buildNumber) throws IOException {
        try {
            String url = PluginDownloader.getUrl(descriptor, host, buildNumber);
            String id = descriptor.getPluginId().getIdString();
            PluginDownloader downloader = new PluginDownloader(id, url, descriptor.getName(), descriptor.getVersion(), buildNumber);
            downloader.setDescriptor(descriptor);
            downloader.setDescription(descriptor.getDescription());
            List<PluginId> depends = descriptor instanceof PluginNode ? ((PluginNode)descriptor).getDepends() : new ArrayList<PluginId>(Arrays.asList(descriptor.getDependentPluginIds()));
            downloader.setDepends(depends);
            return downloader;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    private static String getUrl(@NotNull IdeaPluginDescriptor descriptor, @Nullable String host, @Nullable BuildNumber buildNumber) throws URISyntaxException, MalformedURLException {
        if (host != null && descriptor instanceof PluginNode) {
            String url = ((PluginNode)descriptor).getDownloadUrl();
            return new URI(url).isAbsolute() ? url : new URL(new URL(host), url).toExternalForm();
        }
        Application app = ApplicationManager.getApplication();
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        String buildNumberAsString = buildNumber != null ? buildNumber.asString() : (app != null ? ApplicationInfo.getInstance().getApiVersion() : appInfo.getBuild().asString());
        String uuid = app != null ? UpdateChecker.getInstallationUID(PropertiesComponent.getInstance()) : UUID.randomUUID().toString();
        URIBuilder uriBuilder = new URIBuilder(appInfo.getPluginsDownloadUrl());
        uriBuilder.addParameter("action", "download");
        uriBuilder.addParameter("id", descriptor.getPluginId().getIdString());
        uriBuilder.addParameter("build", buildNumberAsString);
        uriBuilder.addParameter("uuid", uuid);
        return uriBuilder.build().toString();
    }

    @Nullable
    public static PluginNode createPluginNode(@Nullable String host, @NotNull PluginDownloader downloader) {
        IdeaPluginDescriptor descriptor = downloader.getDescriptor();
        if (descriptor instanceof PluginNode) {
            return (PluginNode)descriptor;
        }
        PluginNode node = new PluginNode(PluginId.getId((String)downloader.getPluginId()));
        node.setName(downloader.getPluginName());
        node.setVersion(downloader.getPluginVersion());
        node.setRepositoryName(host);
        node.setDownloadUrl(downloader.myPluginUrl);
        node.setDepends(downloader.getDepends(), null);
        node.setDescription(downloader.getDescription());
        return node;
    }
}

