/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.updateSettings.impl.AbstractUpdateDialog;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

class NewChannelDialog
extends AbstractUpdateDialog {
    private final UpdateChannel myChannel;
    private final BuildInfo myLatestBuild;

    public NewChannelDialog(@NotNull UpdateChannel channel) {
        super(false);
        this.myChannel = channel;
        this.myLatestBuild = channel.getLatestBuild();
        assert (this.myLatestBuild != null);
        this.initLicensingInfo(this.myChannel, this.myLatestBuild);
        this.init();
    }

    protected JComponent createCenterPanel() {
        return new NewChannelPanel().myPanel;
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList actions = ContainerUtil.newArrayList((Object[])new Action[]{this.getOKAction()});
        if (this.myPaidUpgrade) {
            actions.add(new AbstractAction(IdeBundle.message((String)"updates.buy.online.button", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LicensingFacade facade = LicensingFacade.getInstance();
                    assert (facade != null);
                    BrowserUtil.browse((String)facade.getUpgradeUrl());
                    NewChannelDialog.this.doCancelAction();
                }
            });
        }
        actions.add(new AbstractAction(IdeBundle.message((String)"updates.remind.later.button", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateSettings.getInstance().forgetChannelId(NewChannelDialog.this.myChannel.getId());
                NewChannelDialog.this.doCancelAction();
            }
        });
        actions.add(this.getCancelAction());
        return actions.toArray(new Action[actions.size()]);
    }

    @Override
    protected String getOkButtonText() {
        return IdeBundle.message((String)"updates.more.info.button", (Object[])new Object[0]);
    }

    @Override
    protected String getCancelButtonText() {
        return IdeBundle.message((String)"updates.ignore.update.button", (Object[])new Object[0]);
    }

    protected void doOKAction() {
        BrowserUtil.browse((String)this.myChannel.getHomePageUrl());
        super.doOKAction();
    }

    private class NewChannelPanel {
        private JPanel myPanel;
        private JEditorPane myMessageArea;
        private JEditorPane myLicenseArea;

        private NewChannelPanel() {
            Object[] objectArray = new Object[2];
            this.$$$setupUI$$$();
            objectArray[0] = NewChannelDialog.this.myChannel.getName();
            objectArray[1] = NewChannelDialog.this.myLatestBuild.getMessage();
            String message = IdeBundle.message((String)"updates.channel.name.message", (Object[])objectArray);
            NewChannelDialog.this.configureMessageArea(this.myMessageArea, message, null, (HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
            if (NewChannelDialog.this.myLicenseInfo != null) {
                NewChannelDialog.this.configureMessageArea(this.myLicenseArea, NewChannelDialog.this.myLicenseInfo, null, (HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
            } else {
                this.myLicenseArea.setVisible(false);
            }
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JEditorPane jEditorPane;
            JEditorPane jEditorPane2;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            this.myMessageArea = jEditorPane2 = new JEditorPane();
            jEditorPane2.setContentType("text/html");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            jPanel.add((Component)jEditorPane2, gridBagConstraints);
            this.myLicenseArea = jEditorPane = new JEditorPane();
            jEditorPane.setContentType("text/html");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
            jPanel.add((Component)jEditorPane, gridBagConstraints2);
            JPanel jPanel2 = new JPanel();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.fill = 3;
            jPanel.add((Component)jPanel2, gridBagConstraints3);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }
    }
}

