/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsConfigurable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractUpdateDialog
extends DialogWrapper {
    private final boolean myEnableLink;
    protected String myLicenseInfo = null;
    protected boolean myPaidUpgrade;
    protected boolean mySubscriptionLicense = false;

    protected AbstractUpdateDialog(boolean enableLink) {
        super(true);
        this.myEnableLink = enableLink;
        this.setTitle(IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]));
    }

    protected AbstractUpdateDialog(Component parent, boolean enableLink) {
        super(parent, true);
        this.myEnableLink = enableLink;
        this.setTitle(IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]));
    }

    protected void init() {
        this.setOKButtonText(this.getOkButtonText());
        this.setCancelButtonText(this.getCancelButtonText());
        super.init();
    }

    protected String getOkButtonText() {
        return CommonBundle.getOkButtonText();
    }

    protected String getCancelButtonText() {
        return CommonBundle.getCancelButtonText();
    }

    protected void restart() {
        final ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        app.invokeLater(new Runnable(){

            @Override
            public void run() {
                app.restart(true);
            }
        });
    }

    protected void initLicensingInfo(@NotNull UpdateChannel channel, @NotNull BuildInfo build) {
        LicensingFacade facade = LicensingFacade.getInstance();
        if (facade != null) {
            this.mySubscriptionLicense = facade.isSubscriptionLicense();
            if (channel.getLicensing().equals("eap")) {
                this.myLicenseInfo = IdeBundle.message((String)"updates.channel.bundled.key", (Object[])new Object[0]);
            }
        }
    }

    protected void configureMessageArea(@NotNull JEditorPane area) {
        String messageBody = this.myEnableLink ? IdeBundle.message((String)"updates.configure.label", (Object[])new Object[]{ShowSettingsUtil.getSettingsMenuName()}) : "";
        this.configureMessageArea(area, messageBody, null, null);
    }

    protected void configureMessageArea(final @NotNull JEditorPane area, @NotNull String messageBody, @Nullable Color fontColor, @Nullable HyperlinkListener listener2) {
        String text = "<html><head>" + UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont(), (Color)fontColor, null, null) + "<style>body {background: #" + ColorUtil.toHex((Color)UIUtil.getPanelBackground()) + ";}</style>" + "</head><body>" + messageBody + "</body></html>";
        area.setBackground(UIUtil.getPanelBackground());
        area.setBorder(IdeBorderFactory.createEmptyBorder());
        area.setText(text);
        area.setEditable(false);
        if (listener2 == null && this.myEnableLink) {
            listener2 = new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        UpdateSettingsConfigurable settings = new UpdateSettingsConfigurable(false);
                        ShowSettingsUtil.getInstance().editConfigurable((Component)area, (Configurable)settings);
                    }
                }
            };
        }
        if (listener2 != null) {
            area.addHyperlinkListener(listener2);
        }
    }
}

