/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.find.FindBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.ListCellRendererWithRightAlignedComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.list.ListPopupImpl;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FindUsagesInProjectStructureActionBase
extends AnAction
implements DumbAware {
    private final JComponent myParentComponent;
    private final Project myProject;

    public FindUsagesInProjectStructureActionBase(JComponent parentComponent, Project project2) {
        super(ProjectBundle.message((String)"find.usages.action.text", (Object[])new Object[0]), ProjectBundle.message((String)"find.usages.action.text", (Object[])new Object[0]), AllIcons.Actions.Find);
        this.registerCustomShortcutSet(ActionManager.getInstance().getAction("FindUsages").getShortcutSet(), parentComponent);
        this.myParentComponent = parentComponent;
        this.myProject = project2;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(this.isEnabled());
    }

    protected abstract boolean isEnabled();

    public void actionPerformed(AnActionEvent e) {
        ProjectStructureElement selected = this.getSelectedElement();
        if (selected == null) {
            return;
        }
        Collection<ProjectStructureElementUsage> usages = this.getContext().getDaemonAnalyzer().getUsages(selected);
        if (usages.isEmpty()) {
            Messages.showInfoMessage((Component)this.myParentComponent, (String)FindBundle.message("find.usage.view.no.usages.text", new Object[0]), (String)FindBundle.message("find.pointcut.applications.not.found.title", new Object[0]));
            return;
        }
        RelativePoint point = this.getPointToShowResults();
        ProjectStructureElementUsage[] usagesArray = usages.toArray(new ProjectStructureElementUsage[usages.size()]);
        Arrays.sort(usagesArray, new Comparator<ProjectStructureElementUsage>(){

            @Override
            public int compare(ProjectStructureElementUsage o1, ProjectStructureElementUsage o2) {
                return o1.getPresentableName().compareToIgnoreCase(o2.getPresentableName());
            }
        });
        BaseListPopupStep<ProjectStructureElementUsage> step = new BaseListPopupStep<ProjectStructureElementUsage>(ProjectBundle.message((String)"dependencies.used.in.popup.title", (Object[])new Object[0]), usagesArray){

            public PopupStep onChosen(ProjectStructureElementUsage selected, boolean finalChoice) {
                selected.getPlace().navigate();
                return FINAL_CHOICE;
            }

            @NotNull
            public String getTextFor(ProjectStructureElementUsage value) {
                return value.getPresentableName();
            }

            public Icon getIconFor(ProjectStructureElementUsage selection) {
                return selection.getIcon();
            }
        };
        new ListPopupImpl((ListPopupStep)step){

            @Override
            protected ListCellRenderer getListElementRenderer() {
                return new ListCellRendererWithRightAlignedComponent<ProjectStructureElementUsage>(){

                    @Override
                    protected void customize(ProjectStructureElementUsage value) {
                        this.setLeftText(value.getPresentableName());
                        this.setIcon(value.getIcon());
                        this.setRightForeground(Color.GRAY);
                        this.setRightText(value.getPresentableLocationInElement());
                    }
                };
            }
        }.show(point);
    }

    @Nullable
    protected abstract ProjectStructureElement getSelectedElement();

    protected StructureConfigurableContext getContext() {
        return ModuleStructureConfigurable.getInstance(this.myProject).getContext();
    }

    protected abstract RelativePoint getPointToShowResults();
}

