/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.classpath.ChangeLibraryLevelActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ChangeLibraryLevelAction
extends ChangeLibraryLevelActionBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.projectRoot.ChangeLibraryLevelAction");
    private final JComponent myParentComponent;
    private final BaseLibrariesConfigurable mySourceConfigurable;
    private final BaseLibrariesConfigurable myTargetConfigurable;

    public ChangeLibraryLevelAction(@NotNull Project project2, @NotNull JComponent parentComponent, @NotNull BaseLibrariesConfigurable sourceConfigurable, @NotNull BaseLibrariesConfigurable targetConfigurable) {
        super(project2, targetConfigurable.getLibraryTablePresentation().getDisplayName(true), targetConfigurable.getLevel(), sourceConfigurable instanceof GlobalLibrariesConfigurable);
        this.myParentComponent = parentComponent;
        this.mySourceConfigurable = sourceConfigurable;
        this.myTargetConfigurable = targetConfigurable;
    }

    public void actionPerformed(AnActionEvent e) {
        ProjectStructureElement selectedElement = this.mySourceConfigurable.getSelectedElement();
        if (!(selectedElement instanceof LibraryProjectStructureElement)) {
            return;
        }
        final StructureConfigurableContext context = this.mySourceConfigurable.myContext;
        final LibraryProjectStructureElement libraryElement = (LibraryProjectStructureElement)selectedElement;
        final LibraryEx oldLibrary = (LibraryEx)context.getLibrary(libraryElement.getLibrary().getName(), this.mySourceConfigurable.getLevel());
        LOG.assertTrue(oldLibrary != null);
        DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

            @Override
            public void run() {
                Library newLibrary = ChangeLibraryLevelAction.this.doCopy(oldLibrary);
                if (newLibrary == null) {
                    return;
                }
                Collection<ProjectStructureElementUsage> usages = context.getDaemonAnalyzer().getUsages(libraryElement);
                for (ProjectStructureElementUsage usage : usages) {
                    usage.replaceElement(new LibraryProjectStructureElement(context, newLibrary));
                }
                if (!ChangeLibraryLevelAction.this.myCopy) {
                    ChangeLibraryLevelAction.this.mySourceConfigurable.removeLibrary(libraryElement);
                }
                ProjectStructureConfigurable.getInstance(ChangeLibraryLevelAction.this.myProject).selectProjectOrGlobalLibrary(newLibrary, true);
            }
        });
    }

    @Override
    protected boolean isEnabled() {
        return this.mySourceConfigurable.getSelectedElement() instanceof LibraryProjectStructureElement;
    }

    @Override
    protected LibraryTableModifiableModelProvider getModifiableTableModelProvider() {
        return this.myTargetConfigurable.getModelProvider();
    }

    @Override
    protected JComponent getParentComponent() {
        return this.myParentComponent;
    }
}

