/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.NativeLibraryOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.FileTypeBasedRootFilter;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.roots.ui.configuration.LibrarySourceRootDetectorUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLibraryRootsComponentDescriptor
extends LibraryRootsComponentDescriptor {
    private static final Set<String> NATIVE_LIBRARY_EXTENSIONS = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY, (Object[])new String[]{"dll", "so", "dylib"});
    public static final Condition<VirtualFile> LIBRARY_ROOT_CONDITION = new Condition<VirtualFile>(){

        public boolean value(VirtualFile file2) {
            return FileElement.isArchive((VirtualFile)file2) || DefaultLibraryRootsComponentDescriptor.isNativeLibrary(file2);
        }
    };

    @Override
    public OrderRootTypePresentation getRootTypePresentation(@NotNull OrderRootType type) {
        return DefaultLibraryRootsComponentDescriptor.getDefaultPresentation(type);
    }

    @Override
    @NotNull
    public List<? extends AttachRootButtonDescriptor> createAttachButtons() {
        return Arrays.asList(new AttachUrlJavadocDescriptor());
    }

    @Override
    @NotNull
    public List<? extends RootDetector> getRootDetectors() {
        ArrayList<Object> results = new ArrayList<Object>();
        results.add(new FileTypeBasedRootFilter(OrderRootType.CLASSES, false, StdFileTypes.CLASS, "classes"));
        results.add(new FileTypeBasedRootFilter(OrderRootType.CLASSES, true, StdFileTypes.CLASS, "jar directory"));
        results.addAll(Arrays.asList(Extensions.getExtensions(LibrarySourceRootDetectorUtil.JAVA_SOURCE_ROOT_DETECTOR)));
        Collections.addAll(results, new FileTypeBasedRootFilter(OrderRootType.SOURCES, true, (FileType)StdFileTypes.JAVA, "source archive directory"), new JavadocRootDetector(), new AnnotationsRootFilter(), new NativeLibraryRootFilter());
        return results;
    }

    private static boolean isNativeLibrary(VirtualFile file2) {
        String extension = file2.getExtension();
        return extension != null && NATIVE_LIBRARY_EXTENSIONS.contains(extension);
    }

    @Override
    @NotNull
    public FileChooserDescriptor createAttachFilesChooserDescriptor(@Nullable String libraryName) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, true, false, true, true).withFileFilter(LIBRARY_ROOT_CONDITION);
        descriptor.setTitle(StringUtil.isEmpty((String)libraryName) ? ProjectBundle.message((String)"library.attach.files.action", (Object[])new Object[0]) : ProjectBundle.message((String)"library.attach.files.to.library.action", (Object[])new Object[]{libraryName}));
        descriptor.setDescription(ProjectBundle.message((String)"library.java.attach.files.description", (Object[])new Object[0]));
        return descriptor;
    }

    public static OrderRootTypePresentation getDefaultPresentation(OrderRootType type) {
        OrderRootTypeUIFactory factory = (OrderRootTypeUIFactory)OrderRootTypeUIFactory.FACTORY.getByKey((Object)type);
        return new OrderRootTypePresentation(factory.getNodeText(), factory.getIcon());
    }

    private static class AttachUrlJavadocDescriptor
    extends AttachRootButtonDescriptor {
        private AttachUrlJavadocDescriptor() {
            super(JavadocOrderRootType.getInstance(), IconUtil.getAddLinkIcon(), ProjectBundle.message((String)"module.libraries.javadoc.url.button", (Object[])new Object[0]));
        }

        @Override
        public VirtualFile[] selectFiles(@NotNull JComponent parent, @Nullable VirtualFile initialSelection, @Nullable Module contextModule, @NotNull LibraryEditor libraryEditor) {
            VirtualFile vFile = Util.showSpecifyJavadocUrlDialog(parent);
            if (vFile != null) {
                return new VirtualFile[]{vFile};
            }
            return VirtualFile.EMPTY_ARRAY;
        }
    }

    private static class NativeLibraryRootFilter
    extends RootDetector {
        private NativeLibraryRootFilter() {
            super(NativeLibraryOrderRootType.getInstance(), false, "native library location");
        }

        @Override
        @NotNull
        public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
            if (rootCandidate.isInLocalFileSystem()) {
                if (rootCandidate.isDirectory()) {
                    for (VirtualFile file2 : rootCandidate.getChildren()) {
                        if (!DefaultLibraryRootsComponentDescriptor.isNativeLibrary(file2)) continue;
                        return Collections.singleton(rootCandidate);
                    }
                } else if (DefaultLibraryRootsComponentDescriptor.isNativeLibrary(rootCandidate)) {
                    return Collections.singleton(rootCandidate.getParent());
                }
            }
            return Collections.emptyList();
        }
    }

    private static class AnnotationsRootFilter
    extends FileTypeBasedRootFilter {
        private AnnotationsRootFilter() {
            super(AnnotationOrderRootType.getInstance(), false, (FileType)StdFileTypes.XML, "external annotations");
        }

        @Override
        protected boolean isFileAccepted(VirtualFile virtualFile) {
            return super.isFileAccepted(virtualFile) && virtualFile.getName().equals("annotations.xml");
        }
    }

    private static class JavadocRootDetector
    extends RootDetector {
        private JavadocRootDetector() {
            super(JavadocOrderRootType.getInstance(), false, "JavaDocs");
        }

        @Override
        @NotNull
        public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
            JavadocRootDetector.collectJavadocRoots(rootCandidate, result, progressIndicator);
            return result;
        }

        private static void collectJavadocRoots(VirtualFile file2, final List<VirtualFile> result, final ProgressIndicator progressIndicator) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file2) {
                    progressIndicator.checkCanceled();
                    if (file2.isDirectory() && file2.findChild("allclasses-frame.html") != null && file2.findChild("allclasses-noframe.html") != null) {
                        result.add(file2);
                        return false;
                    }
                    return true;
                }
            });
        }
    }
}

