/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathElementChooser;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateModuleLibraryChooser
implements ClasspathElementChooser<Library> {
    private final JComponent myParentComponent;
    private final Module myModule;
    private final LibraryTable.ModifiableModel myModuleLibrariesModel;
    @Nullable
    private final Function<LibraryType, LibraryProperties> myDefaultPropertiesFactory;
    private final HashMap<LibraryRootsComponentDescriptor, LibraryType> myLibraryTypes;
    private final DefaultLibraryRootsComponentDescriptor myDefaultDescriptor;

    public CreateModuleLibraryChooser(ClasspathPanel classpathPanel, LibraryTable.ModifiableModel moduleLibraryModel) {
        this(LibraryEditingUtil.getSuitableTypes(classpathPanel), classpathPanel.getComponent(), classpathPanel.getRootModel().getModule(), moduleLibraryModel, null);
    }

    public CreateModuleLibraryChooser(List<? extends LibraryType> libraryTypes, JComponent parentComponent, Module module2, LibraryTable.ModifiableModel moduleLibrariesModel, @Nullable Function<LibraryType, LibraryProperties> defaultPropertiesFactory) {
        this.myParentComponent = parentComponent;
        this.myModule = module2;
        this.myModuleLibrariesModel = moduleLibrariesModel;
        this.myDefaultPropertiesFactory = defaultPropertiesFactory;
        this.myLibraryTypes = new HashMap();
        this.myDefaultDescriptor = new DefaultLibraryRootsComponentDescriptor();
        for (LibraryType libraryType : libraryTypes) {
            LibraryRootsComponentDescriptor descriptor = null;
            if (libraryType != null) {
                descriptor = libraryType.createLibraryRootsComponentDescriptor();
            }
            if (descriptor == null) {
                descriptor = this.myDefaultDescriptor;
            }
            if (this.myLibraryTypes.containsKey(descriptor)) continue;
            this.myLibraryTypes.put(descriptor, libraryType);
        }
    }

    private Library createLibraryFromRoots(List<OrderRoot> roots, @Nullable LibraryType libraryType) {
        PersistentLibraryKind kind = libraryType == null ? null : libraryType.getKind();
        Library library = this.myModuleLibrariesModel.createLibrary(null, kind);
        LibraryEx.ModifiableModelEx libModel = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        if (this.myDefaultPropertiesFactory != null) {
            libModel.setProperties((LibraryProperties)this.myDefaultPropertiesFactory.fun((Object)libraryType));
        }
        for (OrderRoot root : roots) {
            if (root.isJarDirectory()) {
                libModel.addJarDirectory(root.getFile(), false, root.getType());
                continue;
            }
            libModel.addRoot(root.getFile(), root.getType());
        }
        libModel.commit();
        return library;
    }

    private List<OrderRoot> filterAlreadyAdded(List<OrderRoot> roots) {
        if (roots == null || roots.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OrderRoot> result = new ArrayList<OrderRoot>();
        Library[] libraries = this.myModuleLibrariesModel.getLibraries();
        for (OrderRoot root : roots) {
            if (CreateModuleLibraryChooser.isIncluded(root, libraries)) continue;
            result.add(root);
        }
        return result;
    }

    private static boolean isIncluded(OrderRoot root, Library[] libraries) {
        for (Library library : libraries) {
            if (!ArrayUtil.contains((Object)root.getFile(), (Object[])library.getFiles(root.getType()))) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<Library> chooseElements() {
        LibraryRootsComponentDescriptor rootsComponentDescriptor;
        final ArrayList<Pair> descriptors = new ArrayList<Pair>();
        for (LibraryRootsComponentDescriptor componentDescriptor : this.myLibraryTypes.keySet()) {
            descriptors.add(Pair.create((Object)componentDescriptor, (Object)componentDescriptor.createAttachFilesChooserDescriptor(null)));
        }
        FileChooserDescriptor chooserDescriptor = descriptors.size() == 1 ? (FileChooserDescriptor)((Pair)descriptors.get(0)).getSecond() : new FileChooserDescriptor(true, true, true, false, true, false){

            public boolean isFileSelectable(VirtualFile file2) {
                for (Pair pair : descriptors) {
                    if (!((FileChooserDescriptor)pair.getSecond()).isFileSelectable(file2)) continue;
                    return true;
                }
                return false;
            }

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                for (Pair pair : descriptors) {
                    if (!((FileChooserDescriptor)pair.getSecond()).isFileVisible(file2, showHiddenFiles)) continue;
                    return true;
                }
                return false;
            }
        };
        chooserDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)this.myModule);
        Project project2 = this.myModule.getProject();
        VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)chooserDescriptor, (Component)this.myParentComponent, (Project)project2, (VirtualFile)project2.getBaseDir());
        if (files.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> suitableDescriptors = new ArrayList<Object>();
        for (Pair pair : descriptors) {
            if (!CreateModuleLibraryChooser.acceptAll((FileChooserDescriptor)pair.getSecond(), files)) continue;
            suitableDescriptors.add(pair.getFirst());
        }
        LibraryType libraryType = null;
        if (suitableDescriptors.size() == 1) {
            rootsComponentDescriptor = (LibraryRootsComponentDescriptor)suitableDescriptors.get(0);
            libraryType = this.myLibraryTypes.get(rootsComponentDescriptor);
        } else {
            rootsComponentDescriptor = this.myDefaultDescriptor;
        }
        List<OrderRoot> chosenRoots = RootDetectionUtil.detectRoots(Arrays.asList(files), this.myParentComponent, project2, rootsComponentDescriptor);
        List<OrderRoot> roots = this.filterAlreadyAdded(chosenRoots);
        if (roots.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Library> addedLibraries = new ArrayList<Library>();
        boolean onlyClasses = true;
        for (OrderRoot root : roots) {
            onlyClasses &= root.getType() == OrderRootType.CLASSES;
        }
        if (onlyClasses) {
            for (OrderRoot root : roots) {
                addedLibraries.add(this.createLibraryFromRoots(Collections.singletonList(root), libraryType));
            }
        } else {
            addedLibraries.add(this.createLibraryFromRoots(roots, libraryType));
        }
        return addedLibraries;
    }

    private static boolean acceptAll(FileChooserDescriptor descriptor, VirtualFile[] files) {
        for (VirtualFile file2 : files) {
            if (descriptor.isFileSelectable(file2) && descriptor.isFileVisible(file2, true)) continue;
            return false;
        }
        return true;
    }
}

