/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.ArtifactsTreeNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemNode;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.PackagingSourceItemFilter;
import com.intellij.packaging.ui.PackagingSourceItemsProvider;
import com.intellij.packaging.ui.TreeNodePresentation;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SourceItemNodeBase
extends ArtifactsTreeNode {
    private Artifact myArtifact;
    private final ArtifactEditorEx myArtifactEditor;

    public SourceItemNodeBase(ArtifactEditorContext context, NodeDescriptor parentDescriptor, TreeNodePresentation presentation, ArtifactEditorEx artifactEditor) {
        super(context, parentDescriptor, presentation);
        this.myArtifact = artifactEditor.getArtifact();
        this.myArtifactEditor = artifactEditor;
    }

    protected ArtifactEditorEx getArtifactEditor() {
        return this.myArtifactEditor;
    }

    @Override
    protected void update(PresentationData presentation) {
        Artifact artifact = this.myArtifactEditor.getArtifact();
        if (!this.myArtifact.equals(artifact)) {
            this.myArtifact = artifact;
        }
        super.update(presentation);
    }

    protected SimpleNode[] buildChildren() {
        PackagingSourceItemsProvider[] providers = (PackagingSourceItemsProvider[])PackagingSourceItemsProvider.EP_NAME.getExtensions();
        PackagingSourceItemFilter[] filters = (PackagingSourceItemFilter[])PackagingSourceItemFilter.EP_NAME.getExtensions();
        ArrayList<SourceItemNode> children2 = new ArrayList<SourceItemNode>();
        for (PackagingSourceItemsProvider provider : providers) {
            Collection items = provider.getSourceItems(this.myContext, this.myArtifact, this.getSourceItem());
            for (PackagingSourceItem item : items) {
                if (!this.myArtifact.getArtifactType().isSuitableItem(item) || !SourceItemNodeBase.isAvailable(item, this.myContext, filters)) continue;
                children2.add(new SourceItemNode(this.myContext, (NodeDescriptor)this, item, this.myArtifactEditor));
            }
        }
        return children2.isEmpty() ? NO_CHILDREN : children2.toArray(new SimpleNode[children2.size()]);
    }

    private static boolean isAvailable(@NotNull PackagingSourceItem item, @NotNull ArtifactEditorContext context, @NotNull PackagingSourceItemFilter[] filters) {
        for (PackagingSourceItemFilter filter : filters) {
            if (filter.isAvailable(item, context)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    protected abstract PackagingSourceItem getSourceItem();
}

