/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.PackagingSourceItemsProvider;
import com.intellij.packaging.ui.SourceItemPresentation;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleSourceItemGroup
extends PackagingSourceItem {
    private final Module myModule;

    public ModuleSourceItemGroup(@NotNull Module module2) {
        super(true);
        this.myModule = module2;
    }

    public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        return new ModuleSourceItemPresentation(this.myModule, context);
    }

    public boolean equals(Object obj) {
        return obj instanceof ModuleSourceItemGroup && this.myModule.equals(((ModuleSourceItemGroup)((Object)obj)).myModule);
    }

    public int hashCode() {
        return this.myModule.hashCode();
    }

    @NotNull
    public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
        ModuleSourceItemGroup.collectDependentModules(this.myModule, modules, context);
        Artifact artifact = context.getArtifact();
        ArtifactType artifactType = artifact.getArtifactType();
        LinkedHashSet<PackagingSourceItem> items = new LinkedHashSet<PackagingSourceItem>();
        for (Module module2 : modules) {
            for (PackagingSourceItemsProvider provider : (PackagingSourceItemsProvider[])PackagingSourceItemsProvider.EP_NAME.getExtensions()) {
                ModuleSourceItemGroup parent = new ModuleSourceItemGroup(module2);
                for (PackagingSourceItem sourceItem : provider.getSourceItems(context, artifact, (PackagingSourceItem)parent)) {
                    if (!artifactType.isSuitableItem(sourceItem) || !sourceItem.isProvideElements()) continue;
                    items.add(sourceItem);
                }
            }
        }
        ArrayList result = new ArrayList();
        PackagingElementFactory factory = PackagingElementFactory.getInstance();
        for (PackagingSourceItem item : items) {
            String path = artifactType.getDefaultPathFor(item.getKindOfProducedElements());
            if (path == null) continue;
            result.addAll(factory.createParentDirectories(path, item.createElements(context)));
        }
        return result;
    }

    private static void collectDependentModules(Module module2, Set<Module> modules, ArtifactEditorContext context) {
        if (!modules.add(module2)) {
            return;
        }
        for (OrderEntry entry : context.getModulesProvider().getRootModel(module2).getOrderEntries()) {
            if (!(entry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry moduleEntry = (ModuleOrderEntry)entry;
            Module dependency = moduleEntry.getModule();
            DependencyScope scope = moduleEntry.getScope();
            if (dependency == null || !scope.isForProductionRuntime()) continue;
            ModuleSourceItemGroup.collectDependentModules(dependency, modules, context);
        }
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    private static class ModuleSourceItemPresentation
    extends SourceItemPresentation {
        private final Module myModule;
        private final ArtifactEditorContext myContext;

        public ModuleSourceItemPresentation(@NotNull Module module2, ArtifactEditorContext context) {
            this.myModule = module2;
            this.myContext = context;
        }

        public String getPresentableName() {
            return this.myModule.getName();
        }

        public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
            presentationData.setIcon(ModuleType.get((Module)this.myModule).getIcon());
            presentationData.addText(this.myModule.getName(), mainAttributes);
        }

        public boolean canNavigateToSource() {
            return true;
        }

        public void navigateToSource() {
            this.myContext.selectModule(this.myModule);
        }

        public int getWeight() {
            return 50;
        }
    }
}

