/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.ui.LibraryElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.SourceItemPresentation;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibrarySourceItem
extends PackagingSourceItem {
    private final Library myLibrary;

    public LibrarySourceItem(@NotNull Library library) {
        this.myLibrary = library;
    }

    public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        return new LibrarySourceItemPresentation(this.myLibrary, context);
    }

    public boolean equals(Object obj) {
        return obj instanceof LibrarySourceItem && this.myLibrary.equals(((LibrarySourceItem)((Object)obj)).myLibrary);
    }

    public int hashCode() {
        return this.myLibrary.hashCode();
    }

    @NotNull
    public Library getLibrary() {
        return this.myLibrary;
    }

    @NotNull
    public PackagingElementOutputKind getKindOfProducedElements() {
        return LibraryPackagingElement.getKindForLibrary(this.myLibrary);
    }

    @NotNull
    public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
        return PackagingElementFactory.getInstance().createLibraryElements(this.myLibrary);
    }

    private static class LibrarySourceItemPresentation
    extends SourceItemPresentation {
        private final Library myLibrary;
        private final ArtifactEditorContext myContext;

        public LibrarySourceItemPresentation(Library library, ArtifactEditorContext context) {
            this.myLibrary = library;
            this.myContext = context;
        }

        public boolean canNavigateToSource() {
            return this.myLibrary != null;
        }

        public void navigateToSource() {
            this.myContext.selectLibrary(this.myLibrary);
        }

        public String getPresentableName() {
            return LibraryUtil.getPresentableName((Library)this.myLibrary);
        }

        public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
            String name = this.myLibrary.getName();
            if (name != null) {
                presentationData.setIcon(PlatformIcons.LIBRARY_ICON);
                presentationData.addText(name, mainAttributes);
                presentationData.addText(LibraryElementPresentation.getLibraryTableComment(this.myLibrary), commentAttributes);
            } else {
                if (((LibraryEx)this.myLibrary).isDisposed()) {
                    presentationData.addText("Invalid Library", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    return;
                }
                VirtualFile[] files = this.myLibrary.getFiles(OrderRootType.CLASSES);
                if (files.length > 0) {
                    VirtualFile file2 = files[0];
                    presentationData.setIcon(VirtualFilePresentation.getIcon((VirtualFile)file2));
                    presentationData.addText(file2.getName(), mainAttributes);
                } else {
                    presentationData.addText("Empty Library", SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
            }
        }

        public int getWeight() {
            return 10;
        }
    }
}

