/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.DelegatedSourceItemPresentation;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.impl.artifacts.JarArtifactType;
import com.intellij.packaging.impl.ui.ArtifactElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.SourceItemPresentation;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArtifactSourceItem
extends PackagingSourceItem {
    private final Artifact myArtifact;

    public ArtifactSourceItem(@NotNull Artifact artifact) {
        this.myArtifact = artifact;
    }

    public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        ArtifactPointer pointer = ArtifactPointerManager.getInstance((Project)context.getProject()).createPointer(this.myArtifact, context.getArtifactModel());
        return new DelegatedSourceItemPresentation(new ArtifactElementPresentation(pointer, context)){

            @Override
            public int getWeight() {
                return 150;
            }
        };
    }

    @NotNull
    public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
        Project project2 = context.getProject();
        ArtifactPointer pointer = ArtifactPointerManager.getInstance((Project)project2).createPointer(this.myArtifact, context.getArtifactModel());
        return Collections.singletonList(PackagingElementFactory.getInstance().createArtifactElement(pointer, project2));
    }

    public boolean equals(Object obj) {
        return obj instanceof ArtifactSourceItem && this.myArtifact.equals(((ArtifactSourceItem)((Object)obj)).myArtifact);
    }

    @NotNull
    public PackagingElementOutputKind getKindOfProducedElements() {
        return this.myArtifact.getArtifactType() instanceof JarArtifactType ? PackagingElementOutputKind.JAR_FILES : PackagingElementOutputKind.OTHER;
    }

    public Artifact getArtifact() {
        return this.myArtifact;
    }

    public int hashCode() {
        return this.myArtifact.hashCode();
    }
}

