/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceInArtifact
extends PlaceInProjectStructure {
    private final Artifact myArtifact;
    private final ArtifactsStructureConfigurableContext myContext;
    private final String myParentPath;
    private final PackagingElement<?> myPackagingElement;

    public PlaceInArtifact(Artifact artifact, ArtifactsStructureConfigurableContext context, @Nullable String parentPath, @Nullable PackagingElement<?> packagingElement) {
        this.myArtifact = artifact;
        this.myContext = context;
        this.myParentPath = parentPath;
        this.myPackagingElement = packagingElement;
    }

    @Override
    @NotNull
    public ProjectStructureElement getContainingElement() {
        return this.myContext.getOrCreateArtifactElement(this.myArtifact);
    }

    @Override
    public String getPlacePath() {
        if (this.myParentPath != null && this.myPackagingElement != null) {
            return this.myParentPath + "/" + this.myPackagingElement.getType().getId();
        }
        return null;
    }

    @Override
    @NotNull
    public ActionCallback navigate() {
        final Artifact artifact = this.myContext.getArtifactModel().getArtifactByOriginal(this.myArtifact);
        return ProjectStructureConfigurable.getInstance(this.myContext.getProject()).select(this.myArtifact, true).doWhenDone(new Runnable(){

            @Override
            public void run() {
                ArtifactEditorEx artifactEditor = (ArtifactEditorEx)PlaceInArtifact.this.myContext.getOrCreateEditor(artifact);
                if (PlaceInArtifact.this.myParentPath != null && PlaceInArtifact.this.myPackagingElement != null) {
                    artifactEditor.getLayoutTreeComponent().selectNode(PlaceInArtifact.this.myParentPath, PlaceInArtifact.this.myPackagingElement);
                }
            }
        });
    }
}

