/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class LanguageLevelCombo
extends ComboBox {
    private boolean myDefaultWasSelectedBeforeRemoving;
    private final String myDefaultItem;

    public LanguageLevelCombo(String defaultItem) {
        this.myDefaultItem = defaultItem;
        for (LanguageLevel level : LanguageLevel.values()) {
            this.addItem(level);
        }
        this.setRenderer((ListCellRenderer)new ColoredListCellRendererWrapper(){

            protected void doCustomize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof LanguageLevel) {
                    this.append(((LanguageLevel)value).getPresentableText());
                } else if (value instanceof String) {
                    this.append((String)value);
                    LanguageLevel defaultLevel = LanguageLevelCombo.this.getDefaultLevel();
                    if (defaultLevel != null) {
                        this.append(" (" + defaultLevel.getPresentableText() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            }
        });
    }

    public void reset(@NotNull Project project2) {
        this.removeAllItems();
        for (LanguageLevel level : LanguageLevel.values()) {
            this.addItem(level);
        }
        Sdk sdk = ProjectRootManagerEx.getInstanceEx((Project)project2).getProjectSdk();
        this.sdkUpdated(sdk, project2.isDefault());
        LanguageLevelProjectExtension extension = LanguageLevelProjectExtension.getInstance((Project)project2);
        if (extension.isDefault()) {
            this.setSelectedItem(this.myDefaultItem);
        } else {
            this.setSelectedItem(extension.getLanguageLevel());
        }
    }

    protected abstract LanguageLevel getDefaultLevel();

    void sdkUpdated(Sdk sdk, boolean isDefaultProject) {
        JavaSdkVersion version;
        LanguageLevel newLevel = null;
        if (sdk != null && (version = JavaSdk.getInstance().getVersion(sdk)) != null) {
            newLevel = version.getMaxLanguageLevel();
        }
        this.updateDefaultLevel(newLevel, isDefaultProject);
    }

    private void updateDefaultLevel(LanguageLevel newLevel, boolean isDefaultProject) {
        if (newLevel == null && !isDefaultProject) {
            if (this.isDefaultItemAdded()) {
                boolean defaultSelected;
                boolean bl = defaultSelected = this.getSelectedItem() == this.myDefaultItem;
                if (defaultSelected) {
                    this.setSelectedItem(this.getDefaultLevel());
                }
                this.myDefaultWasSelectedBeforeRemoving = defaultSelected;
                this.removeItem(this.myDefaultItem);
            }
        } else if (!this.isDefaultItemAdded()) {
            this.addDefaultItem();
            if (this.myDefaultWasSelectedBeforeRemoving) {
                this.setSelectedIndex(0);
            }
        }
        this.repaint();
    }

    private boolean isDefaultItemAdded() {
        return this.getItemAt(0) instanceof String;
    }

    void addDefaultItem() {
        this.insertItemAt(this.myDefaultItem, 0);
    }

    public LanguageLevel getSelectedLevel() {
        Object item = this.getSelectedItem();
        return item instanceof LanguageLevel ? (LanguageLevel)item : this.getDefaultLevel();
    }

    public boolean isDefault() {
        return !(this.getSelectedItem() instanceof LanguageLevel);
    }

    public void setSelectedItem(Object anObject) {
        super.setSelectedItem(anObject == null ? this.myDefaultItem : anObject);
    }
}

