/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaContentEntryEditor
extends ContentEntryEditor {
    private final CompilerModuleExtension myCompilerExtension = (CompilerModuleExtension)this.getModel().getModuleExtension(CompilerModuleExtension.class);

    public JavaContentEntryEditor(String contentEntryUrl, List<ModuleSourceRootEditHandler<?>> moduleSourceRootEditHandlers) {
        super(contentEntryUrl, moduleSourceRootEditHandlers);
    }

    @Override
    protected ContentRootPanel createContentRootPane() {
        return new ContentRootPanel(this, this.getEditHandlers()){

            @Override
            @Nullable
            protected ContentEntry getContentEntry() {
                return JavaContentEntryEditor.this.getContentEntry();
            }

            @Override
            @Nullable
            protected JComponent createRootPropertiesEditor(ModuleSourceRootEditHandler<?> editor, SourceFolder folder) {
                return editor.createPropertiesEditor(folder, this, this.myCallback);
            }
        };
    }

    @Override
    protected ExcludeFolder doAddExcludeFolder(@NotNull VirtualFile file2) {
        boolean isCompilerOutput = this.isCompilerOutput(file2.getUrl());
        if (isCompilerOutput) {
            this.myCompilerExtension.setExcludeOutput(true);
            return null;
        }
        return super.doAddExcludeFolder(file2);
    }

    @Override
    protected void doRemoveExcludeFolder(@NotNull String excludeRootUrl) {
        if (this.isCompilerOutput(excludeRootUrl)) {
            this.myCompilerExtension.setExcludeOutput(false);
        }
        super.doRemoveExcludeFolder(excludeRootUrl);
    }

    private boolean isCompilerOutput(@NotNull String fileUrl) {
        ProjectStructureConfigurable instance;
        String compilerOutputUrl;
        if (fileUrl.equals(this.myCompilerExtension.getCompilerOutputUrl())) {
            return true;
        }
        if (fileUrl.equals(this.myCompilerExtension.getCompilerOutputUrlForTests())) {
            return true;
        }
        return this.myCompilerExtension.isCompilerOutputPathInherited() && fileUrl.equals(compilerOutputUrl = (instance = ProjectStructureConfigurable.getInstance(this.getModel().getModule().getProject())).getProjectConfig().getCompilerOutputUrl());
    }
}

