/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ConfigurationError;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.PairProcessor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.awt.EventQueue;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public interface ConfigurationErrors {
    public static final Topic<ConfigurationErrors> TOPIC = Topic.create((String)"Configuration Error", ConfigurationErrors.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.NONE);

    public void addError(@NotNull ConfigurationError var1);

    public void removeError(@NotNull ConfigurationError var1);

    public static class Bus {
        public static void addError(@NotNull ConfigurationError error, @NotNull Project project2) {
            Bus._do(error, project2, new PairProcessor<ConfigurationErrors, ConfigurationError>(){

                public boolean process(ConfigurationErrors configurationErrors, ConfigurationError configurationError) {
                    configurationErrors.addError(configurationError);
                    return false;
                }
            });
        }

        public static void removeError(@NotNull ConfigurationError error, @NotNull Project project2) {
            Bus._do(error, project2, new PairProcessor<ConfigurationErrors, ConfigurationError>(){

                public boolean process(ConfigurationErrors configurationErrors, ConfigurationError configurationError) {
                    configurationErrors.removeError(configurationError);
                    return false;
                }
            });
        }

        public static void _do(final @NotNull ConfigurationError error, final @NotNull Project project2, final @NotNull PairProcessor<ConfigurationErrors, ConfigurationError> fun) {
            if (!project2.isInitialized()) {
                StartupManager.getInstance((Project)project2).runWhenProjectIsInitialized(new Runnable(){

                    @Override
                    public void run() {
                        fun.process(project2.getMessageBus().syncPublisher(TOPIC), (Object)error);
                    }
                });
                return;
            }
            final MessageBus bus = project2.getMessageBus();
            if (EventQueue.isDispatchThread()) {
                fun.process(bus.syncPublisher(TOPIC), (Object)error);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        fun.process(bus.syncPublisher(TOPIC), (Object)error);
                    }
                });
            }
        }
    }
}

