/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryType<P extends LibraryProperties>
extends LibraryPresentationProvider<P> {
    public static final ExtensionPointName<LibraryType<?>> EP_NAME = ExtensionPointName.create((String)"com.intellij.library.type");
    public static final OrderRootType[] DEFAULT_EXTERNAL_ROOT_TYPES = new OrderRootType[]{OrderRootType.CLASSES};

    protected LibraryType(@NotNull PersistentLibraryKind<P> libraryKind) {
        super((LibraryKind)libraryKind);
    }

    @NotNull
    public PersistentLibraryKind<P> getKind() {
        return (PersistentLibraryKind)super.getKind();
    }

    @Nullable
    public abstract String getCreateActionName();

    @Nullable
    public abstract NewLibraryConfiguration createNewLibrary(@NotNull JComponent var1, @Nullable VirtualFile var2, @NotNull Project var3);

    public boolean isSuitableModule(@NotNull Module module2, @NotNull FacetsProvider facetsProvider) {
        return true;
    }

    @Nullable
    public LibraryRootsComponentDescriptor createLibraryRootsComponentDescriptor() {
        return null;
    }

    @Nullable
    public abstract LibraryPropertiesEditor createPropertiesEditor(@NotNull LibraryEditorComponent<P> var1);

    @Override
    public P detect(@NotNull List<VirtualFile> classesRoots) {
        return null;
    }

    public OrderRootType[] getExternalRootTypes() {
        return DEFAULT_EXTERNAL_ROOT_TYPES;
    }

    public static LibraryType findByKind(LibraryKind kind) {
        for (LibraryType type : (LibraryType[])EP_NAME.getExtensions()) {
            if (type.getKind() != kind) continue;
            return type;
        }
        throw new IllegalArgumentException("Library with kind " + kind + " is not registered");
    }
}

