/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.roots.libraries.LibraryDetectionManager;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryDetectionManagerImpl
extends LibraryDetectionManager {
    private final Map<List<VirtualFile>, List<Pair<LibraryKind, LibraryProperties>>> myCache = Collections.synchronizedMap(new HashMap());

    @Override
    public boolean processProperties(@NotNull List<VirtualFile> files, @NotNull LibraryDetectionManager.LibraryPropertiesProcessor processor2) {
        for (Pair<LibraryKind, LibraryProperties> pair : this.getOrComputeKinds(files)) {
            if (processor2.processProperties((LibraryKind)pair.getFirst(), (LibraryProperties)pair.getSecond())) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public Pair<LibraryType<?>, LibraryProperties<?>> detectType(@NotNull List<VirtualFile> files) {
        Pair result = null;
        for (LibraryType type : (LibraryType[])LibraryType.EP_NAME.getExtensions()) {
            Object properties = type.detect(files);
            if (properties == null) continue;
            if (result != null) {
                return null;
            }
            result = Pair.create((Object)type, properties);
        }
        return result;
    }

    private List<Pair<LibraryKind, LibraryProperties>> getOrComputeKinds(List<VirtualFile> files) {
        List<Pair<LibraryKind, LibraryProperties>> result = this.myCache.get(files);
        if (result == null) {
            result = LibraryDetectionManagerImpl.computeKinds(files);
            this.myCache.put(files, result);
        }
        return result;
    }

    private static List<Pair<LibraryKind, LibraryProperties>> computeKinds(List<VirtualFile> files) {
        SmartList result = new SmartList();
        LibraryType[] libraryTypes = (LibraryType[])LibraryType.EP_NAME.getExtensions();
        LibraryPresentationProvider[] presentationProviders = (LibraryPresentationProvider[])LibraryPresentationProvider.EP_NAME.getExtensions();
        for (LibraryPresentationProvider provider : ContainerUtil.concat((Object[][])new LibraryPresentationProvider[][]{libraryTypes, presentationProviders})) {
            Object properties = provider.detect(files);
            if (properties == null) continue;
            result.add((Object)Pair.create((Object)provider.getKind(), properties));
        }
        return result;
    }
}

