/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModuleOrderEnumerator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class RootModelBase
implements ModuleRootModel {
    @NotNull
    public VirtualFile[] getContentRoots() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (ContentEntry contentEntry : this.getContent()) {
            VirtualFile file2 = contentEntry.getFile();
            if (file2 == null) continue;
            result.add(file2);
        }
        return VfsUtilCore.toVirtualFileArray(result);
    }

    @NotNull
    public String[] getContentRootUrls() {
        if (this.getContent().isEmpty()) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result = new ArrayList<String>(this.getContent().size());
        for (ContentEntry contentEntry : this.getContent()) {
            result.add(contentEntry.getUrl());
        }
        return ArrayUtil.toStringArray(result);
    }

    @NotNull
    public String[] getExcludeRootUrls() {
        SmartList result = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            result.addAll(contentEntry.getExcludeFolderUrls());
        }
        return ArrayUtil.toStringArray((Collection)result);
    }

    @NotNull
    public VirtualFile[] getExcludeRoots() {
        SmartList result = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            Collections.addAll(result, contentEntry.getExcludeFolderFiles());
        }
        return VfsUtilCore.toVirtualFileArray((Collection)result);
    }

    @NotNull
    public String[] getSourceRootUrls() {
        return this.getSourceRootUrls(true);
    }

    @NotNull
    public String[] getSourceRootUrls(boolean includingTests) {
        SmartList result = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            SourceFolder[] sourceFolders;
            for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                if (!includingTests && sourceFolder.isTestSource()) continue;
                result.add(sourceFolder.getUrl());
            }
        }
        return ArrayUtil.toStringArray((Collection)result);
    }

    @NotNull
    public VirtualFile[] getSourceRoots() {
        return this.getSourceRoots(true);
    }

    @NotNull
    public VirtualFile[] getSourceRoots(boolean includingTests) {
        SmartList result = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            SourceFolder[] sourceFolders;
            for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                VirtualFile file2 = sourceFolder.getFile();
                if (file2 == null || !includingTests && sourceFolder.isTestSource()) continue;
                result.add(file2);
            }
        }
        return VfsUtilCore.toVirtualFileArray((Collection)result);
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull JpsModuleSourceRootType<?> rootType) {
        return this.getSourceRoots(Collections.singleton(rootType));
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        SmartList result = new SmartList();
        for (ContentEntry contentEntry : this.getContent()) {
            List sourceFolders = contentEntry.getSourceFolders(rootTypes);
            for (SourceFolder sourceFolder : sourceFolders) {
                VirtualFile file2 = sourceFolder.getFile();
                if (file2 == null) continue;
                result.add(file2);
            }
        }
        return result;
    }

    @NotNull
    public ContentEntry[] getContentEntries() {
        Collection<ContentEntry> content = this.getContent();
        return content.toArray(new ContentEntry[content.size()]);
    }

    protected abstract Collection<ContentEntry> getContent();

    public Sdk getSdk() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof JdkOrderEntry)) continue;
            return ((JdkOrderEntry)orderEntry).getJdk();
        }
        return null;
    }

    public boolean isSdkInherited() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof InheritedJdkOrderEntry)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public OrderEnumerator orderEntries() {
        return new ModuleOrderEnumerator(this, null);
    }

    public <R> R processOrder(RootPolicy<R> policy, R initialValue) {
        Object result = initialValue;
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            result = orderEntry.accept(policy, result);
        }
        return result;
    }

    @NotNull
    public String[] getDependencyModuleNames() {
        List result = (List)this.orderEntries().withoutSdk().withoutLibraries().withoutModuleSourceEntries().process((RootPolicy)new CollectDependentModules(), new ArrayList());
        return ArrayUtil.toStringArray((Collection)result);
    }

    @NotNull
    public Module[] getModuleDependencies() {
        return this.getModuleDependencies(true);
    }

    @NotNull
    public Module[] getModuleDependencies(boolean includeTests) {
        OrderEntry[] entries = this.getOrderEntries();
        ArrayList<Module> result = new ArrayList<Module>(entries.length);
        for (OrderEntry entry : entries) {
            Module module2;
            if (!(entry instanceof ModuleOrderEntry)) continue;
            DependencyScope scope = ((ModuleOrderEntry)entry).getScope();
            if (!includeTests && !scope.isForProductionCompile() && !scope.isForProductionRuntime() || (module2 = ((ModuleOrderEntry)entry).getModule()) == null) continue;
            result.add(module2);
        }
        return result.isEmpty() ? Module.EMPTY_ARRAY : (Module[])ContainerUtil.toArray(result, (Object[])new Module[result.size()]);
    }

    private static class CollectDependentModules
    extends RootPolicy<List<String>> {
        private CollectDependentModules() {
        }

        @NotNull
        public List<String> visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, @NotNull List<String> arrayList) {
            arrayList.add(moduleOrderEntry.getModuleName());
            return arrayList;
        }
    }
}

