/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.WatchedRootsProvider;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.roots.impl.ModuleRootEventImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.ex.VirtualFileManagerAdapter;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectRootManagerComponent
extends ProjectRootManagerImpl
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance(ProjectRootManagerComponent.class);
    private boolean myPointerChangesDetected = false;
    private int myInsideRefresh = 0;
    private final BatchUpdateListener myHandler;
    private final MessageBusConnection myConnection;
    private Set<LocalFileSystem.WatchRequest> myRootsToWatch = new THashSet();
    private final boolean myDoLogCachesUpdate;

    public ProjectRootManagerComponent(Project project2, StartupManager startupManager) {
        super(project2);
        this.myConnection = project2.getMessageBus().connect((Disposable)project2);
        this.myConnection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void beforeFileTypesChanged(@NotNull FileTypeEvent event) {
                ProjectRootManagerComponent.this.beforeRootsChange(true);
            }

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                ProjectRootManagerComponent.this.rootsChanged(true);
            }
        });
        VirtualFileManager.getInstance().addVirtualFileManagerListener((VirtualFileManagerListener)new VirtualFileManagerAdapter(){

            @Override
            public void afterRefreshFinish(boolean asynchronous) {
                ProjectRootManagerComponent.this.doUpdateOnRefresh();
            }
        }, (Disposable)project2);
        startupManager.registerStartupActivity(new Runnable(){

            @Override
            public void run() {
                ProjectRootManagerComponent.this.myStartupActivityPerformed = true;
            }
        });
        this.myHandler = new BatchUpdateListener(){

            @Override
            public void onBatchUpdateStarted() {
                ProjectRootManagerComponent.this.myRootsChanged.levelUp();
                ProjectRootManagerComponent.this.myFileTypesChanged.levelUp();
            }

            @Override
            public void onBatchUpdateFinished() {
                ProjectRootManagerComponent.this.myRootsChanged.levelDown();
                ProjectRootManagerComponent.this.myFileTypesChanged.levelDown();
            }
        };
        this.myConnection.subscribe(VirtualFilePointerListener.TOPIC, (Object)new MyVirtualFilePointerListener());
        this.myDoLogCachesUpdate = false;
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        return "ProjectRootManager";
    }

    public void initComponent() {
        this.myConnection.subscribe(BatchUpdateListener.TOPIC, (Object)this.myHandler);
    }

    public void projectOpened() {
        this.addRootsToWatch();
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new AppListener(), (Disposable)this.myProject);
    }

    public void projectClosed() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myRootsToWatch);
    }

    @Override
    protected void addRootsToWatch() {
        Pair<Set<String>, Set<String>> roots = this.getAllRoots(false);
        if (roots == null) {
            return;
        }
        this.myRootsToWatch = LocalFileSystem.getInstance().replaceWatchedRoots(this.myRootsToWatch, (Collection)roots.first, (Collection)roots.second);
    }

    private void beforeRootsChange(boolean fileTypes) {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.getBatchSession(fileTypes).beforeRootsChanged();
    }

    private void rootsChanged(boolean fileTypes) {
        this.getBatchSession(fileTypes).rootsChanged();
    }

    private void doUpdateOnRefresh() {
        if (ApplicationManager.getApplication().isUnitTestMode() && (!this.myStartupActivityPerformed || this.myProject.isDisposed())) {
            return;
        }
        if (this.myProject.isDefault()) {
            return;
        }
        if (this.myDoLogCachesUpdate) {
            LOG.debug("refresh");
        }
        DumbServiceImpl dumbService = DumbServiceImpl.getInstance(this.myProject);
        DumbModeTask task = FileBasedIndexProjectHandler.createChangedFilesIndexingTask(this.myProject);
        if (task != null) {
            dumbService.queueTask(task);
        }
    }

    private boolean affectsRoots(VirtualFilePointer[] pointers) {
        Pair<Set<String>, Set<String>> roots = this.getAllRoots(true);
        if (roots == null) {
            return false;
        }
        for (VirtualFilePointer pointer : pointers) {
            String path = ProjectRootManagerComponent.url2path(pointer.getUrl());
            if (!((Set)roots.first).contains(path) && !((Set)roots.second).contains(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void fireBeforeRootsChangeEvent(boolean fileTypes) {
        this.isFiringEvent = true;
        try {
            ((ModuleRootListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).beforeRootsChange((ModuleRootEvent)new ModuleRootEventImpl(this.myProject, fileTypes));
        }
        finally {
            this.isFiringEvent = false;
        }
    }

    @Override
    protected void fireRootsChangedEvent(boolean fileTypes) {
        this.isFiringEvent = true;
        try {
            ((ModuleRootListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).rootsChanged((ModuleRootEvent)new ModuleRootEventImpl(this.myProject, fileTypes));
        }
        finally {
            this.isFiringEvent = false;
        }
    }

    private static String url2path(String url) {
        String path = VfsUtilCore.urlToPath((String)url);
        int separatorIndex = path.indexOf("!/");
        if (separatorIndex < 0) {
            return path;
        }
        return path.substring(0, separatorIndex);
    }

    @Nullable
    private Pair<Set<String>, Set<String>> getAllRoots(boolean includeSourceRoots) {
        Module[] modules;
        File projectDirFile;
        if (this.myProject.isDefault()) {
            return null;
        }
        HashSet recursive = new HashSet();
        HashSet flat = new HashSet();
        String projectFilePath = this.myProject.getProjectFilePath();
        File file2 = projectDirFile = projectFilePath == null ? null : new File(projectFilePath).getParentFile();
        if (projectDirFile != null && projectDirFile.getName().equals(".idea")) {
            recursive.add(projectDirFile.getAbsolutePath());
        } else {
            flat.add(projectFilePath);
            ContainerUtil.addIfNotNull((Collection)flat, (Object)((IProjectStore)ServiceKt.getStateStore((ComponentManager)this.myProject)).getWorkspaceFilePath());
        }
        for (WatchedRootsProvider extension : (WatchedRootsProvider[])Extensions.getExtensions((ExtensionPointName)WatchedRootsProvider.EP_NAME, (AreaInstance)this.myProject)) {
            recursive.addAll(extension.getRootsToWatch());
        }
        for (Module module2 : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            OrderEntry[] orderEntries;
            flat.add(module2.getModuleFilePath());
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
            ProjectRootManagerComponent.addRootsToTrack(moduleRootManager.getContentRootUrls(), (Collection<String>)recursive, (Collection<String>)flat);
            if (includeSourceRoots) {
                ProjectRootManagerComponent.addRootsToTrack(moduleRootManager.getSourceRootUrls(), (Collection<String>)recursive, (Collection<String>)flat);
            }
            for (OrderEntry entry : orderEntries = moduleRootManager.getOrderEntries()) {
                if (!(entry instanceof LibraryOrSdkOrderEntry)) continue;
                LibraryOrSdkOrderEntry libSdkEntry = (LibraryOrSdkOrderEntry)entry;
                for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
                    ProjectRootManagerComponent.addRootsToTrack(libSdkEntry.getRootUrls(orderRootType), (Collection<String>)recursive, (Collection<String>)flat);
                }
            }
        }
        return Pair.create((Object)recursive, (Object)flat);
    }

    private static void addRootsToTrack(String[] urls, Collection<String> recursive, Collection<String> flat) {
        for (String url : urls) {
            if (url == null) continue;
            String protocol = VirtualFileManager.extractProtocol((String)url);
            if (protocol == null || "file".equals(protocol)) {
                recursive.add(ProjectRootManagerComponent.extractLocalPath(url));
                continue;
            }
            if ("jar".equals(protocol)) {
                flat.add(ProjectRootManagerComponent.extractLocalPath(url));
                continue;
            }
            if (!"jrt".equals(protocol)) continue;
            recursive.add(ProjectRootManagerComponent.extractLocalPath(url));
        }
    }

    @Override
    protected void doSynchronizeRoots() {
        if (!this.myStartupActivityPerformed) {
            return;
        }
        if (this.myDoLogCachesUpdate) {
            LOG.debug(new Throwable("sync roots"));
        } else {
            LOG.info("project roots have changed");
        }
        DumbServiceImpl dumbService = DumbServiceImpl.getInstance(this.myProject);
        if (FileBasedIndex.getInstance() instanceof FileBasedIndexImpl) {
            dumbService.queueTask(new UnindexedFilesUpdater(this.myProject, false));
        }
    }

    @Override
    protected void clearScopesCaches() {
        super.clearScopesCaches();
        LibraryScopeCache.getInstance(this.myProject).clear();
    }

    @Override
    public void clearScopesCachesForModules() {
        Module[] modules;
        super.clearScopesCachesForModules();
        for (Module module2 : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ((ModuleEx)module2).clearScopesCache();
        }
    }

    private class MyVirtualFilePointerListener
    implements VirtualFilePointerListener {
        private MyVirtualFilePointerListener() {
        }

        public void beforeValidityChanged(@NotNull VirtualFilePointer[] pointers) {
            if (!ProjectRootManagerComponent.this.myProject.isDisposed()) {
                if (ProjectRootManagerComponent.this.myInsideRefresh == 0) {
                    if (ProjectRootManagerComponent.this.affectsRoots(pointers)) {
                        ProjectRootManagerComponent.this.beforeRootsChange(false);
                        if (ProjectRootManagerComponent.this.myDoLogCachesUpdate) {
                            LOG.debug(new Throwable(pointers.length > 0 ? pointers[0].getPresentableUrl() : ""));
                        }
                    }
                } else if (!ProjectRootManagerComponent.this.myPointerChangesDetected && ProjectRootManagerComponent.this.affectsRoots(pointers)) {
                    ProjectRootManagerComponent.this.myPointerChangesDetected = true;
                    ((ModuleRootListener)ProjectRootManagerComponent.this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).beforeRootsChange((ModuleRootEvent)new ModuleRootEventImpl(ProjectRootManagerComponent.this.myProject, false));
                    if (ProjectRootManagerComponent.this.myDoLogCachesUpdate) {
                        LOG.debug(new Throwable(pointers.length > 0 ? pointers[0].getPresentableUrl() : ""));
                    }
                }
            }
        }

        public void validityChanged(@NotNull VirtualFilePointer[] pointers) {
            if (!ProjectRootManagerComponent.this.myProject.isDisposed()) {
                if (ProjectRootManagerComponent.this.myInsideRefresh > 0) {
                    ProjectRootManagerComponent.this.clearScopesCaches();
                } else if (ProjectRootManagerComponent.this.affectsRoots(pointers)) {
                    ProjectRootManagerComponent.this.rootsChanged(false);
                }
            }
        }
    }

    private class AppListener
    extends ApplicationAdapter {
        private AppListener() {
        }

        public void beforeWriteActionStart(Object action) {
            ProjectRootManagerComponent.this.myInsideRefresh++;
        }

        public void writeActionFinished(Object action) {
            if (--ProjectRootManagerComponent.this.myInsideRefresh == 0 && ProjectRootManagerComponent.this.myPointerChangesDetected) {
                ProjectRootManagerComponent.this.myPointerChangesDetected = false;
                ((ModuleRootListener)ProjectRootManagerComponent.this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).rootsChanged((ModuleRootEvent)new ModuleRootEventImpl(ProjectRootManagerComponent.this.myProject, false));
                ProjectRootManagerComponent.this.doSynchronizeRoots();
                ProjectRootManagerComponent.this.addRootsToWatch();
            }
        }
    }
}

