/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModulesOrderEnumerator
extends OrderEnumeratorBase {
    private final Collection<? extends Module> myModules;

    public ModulesOrderEnumerator(@NotNull Collection<? extends Module> modules) {
        super(null);
        this.myModules = modules;
    }

    @Override
    public void processRootModules(@NotNull Processor<Module> processor2) {
        for (Module module2 : this.myModules) {
            processor2.process((Object)module2);
        }
    }

    @Override
    protected void forEach(@NotNull PairProcessor<OrderEntry, List<OrderEnumerationHandler>> processor2) {
        this.myRecursivelyExportedOnly = false;
        THashSet processed2 = new THashSet();
        for (Module module2 : this.myModules) {
            this.processEntries(this.getRootModel(module2), processor2, (Set<Module>)processed2, true, ModulesOrderEnumerator.getCustomHandlers(module2));
        }
    }

    @Override
    public boolean isRootModuleModel(@NotNull ModuleRootModel rootModel) {
        return this.myModules.contains(rootModel.getModule());
    }
}

