/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.ModuleOrderEnumerator;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ModuleRootManagerImpl
extends ModuleRootManager
implements ModuleComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.ModuleRootManagerImpl");
    private final Module myModule;
    private final ProjectRootManagerImpl myProjectRootManager;
    private final VirtualFilePointerManager myFilePointerManager;
    private RootModelImpl myRootModel;
    private boolean myIsDisposed = false;
    private boolean myLoaded = false;
    private boolean isModuleAdded = false;
    private final OrderRootsCache myOrderRootsCache;
    private final Map<RootModelImpl, Throwable> myModelCreations = new THashMap();

    public ModuleRootManagerImpl(Module module2, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        this.myModule = module2;
        this.myProjectRootManager = projectRootManager;
        this.myFilePointerManager = filePointerManager;
        this.myRootModel = new RootModelImpl(this, this.myProjectRootManager, this.myFilePointerManager);
        this.myOrderRootsCache = new OrderRootsCache((Disposable)module2);
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public ModuleFileIndex getFileIndex() {
        return (ModuleFileIndex)ModuleServiceManager.getService((Module)this.myModule, ModuleFileIndex.class);
    }

    @NotNull
    public String getComponentName() {
        return "NewModuleRootManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.myRootModel.dispose();
        this.myIsDisposed = true;
        if (Disposer.isDebugMode()) {
            Set<Map.Entry<RootModelImpl, Throwable>> entries = this.myModelCreations.entrySet();
            for (Map.Entry<RootModelImpl, Throwable> entry : new ArrayList<Map.Entry<RootModelImpl, Throwable>>(entries)) {
                System.err.println("***********************************************************************************************");
                System.err.println("***                        R O O T   M O D E L   N O T   D I S P O S E D                    ***");
                System.err.println("***********************************************************************************************");
                System.err.println("Created at:");
                entry.getValue().printStackTrace(System.err);
                entry.getKey().dispose();
            }
        }
    }

    @NotNull
    public ModifiableRootModel getModifiableModel() {
        return this.getModifiableModel(new RootConfigurationAccessor());
    }

    @NotNull
    public ModifiableRootModel getModifiableModel(RootConfigurationAccessor accessor) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootModelImpl model = new RootModelImpl(this.myRootModel, this, true, accessor, this.myFilePointerManager, this.myProjectRootManager){

            @Override
            public void dispose() {
                super.dispose();
                if (Disposer.isDebugMode()) {
                    ModuleRootManagerImpl.this.myModelCreations.remove(this);
                }
                for (OrderEntry entry : ModuleRootManagerImpl.this.getOrderEntries()) {
                    assert (!((RootModelComponentBase)entry).isDisposed()) : String.format("%s is not disposed!", entry.getPresentableName());
                }
            }
        };
        if (Disposer.isDebugMode()) {
            this.myModelCreations.put(model, new Throwable());
        }
        return model;
    }

    void makeRootsChange(@NotNull Runnable runnable2) {
        ProjectRootManagerEx projectRootManagerEx = (ProjectRootManagerEx)ProjectRootManager.getInstance((Project)this.myModule.getProject());
        projectRootManagerEx.makeRootsChange(runnable2, false, this.isModuleAdded);
    }

    public RootModelImpl getRootModel() {
        return this.myRootModel;
    }

    @NotNull
    public ContentEntry[] getContentEntries() {
        return this.myRootModel.getContentEntries();
    }

    @NotNull
    public OrderEntry[] getOrderEntries() {
        return this.myRootModel.getOrderEntries();
    }

    public Sdk getSdk() {
        return this.myRootModel.getSdk();
    }

    public boolean isSdkInherited() {
        return this.myRootModel.isSdkInherited();
    }

    void commitModel(RootModelImpl rootModel) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(rootModel.myModuleRootManager == this);
        Project project2 = this.myModule.getProject();
        ModifiableModuleModel moduleModel = ModuleManager.getInstance((Project)project2).getModifiableModel();
        ModifiableModelCommitter.multiCommit(new ModifiableRootModel[]{rootModel}, moduleModel);
    }

    static void doCommit(RootModelImpl rootModel) {
        rootModel.docommit();
        rootModel.dispose();
    }

    @NotNull
    public Module[] getDependencies() {
        return this.myRootModel.getModuleDependencies();
    }

    @NotNull
    public Module[] getDependencies(boolean includeTests) {
        return this.myRootModel.getModuleDependencies(includeTests);
    }

    @NotNull
    public Module[] getModuleDependencies() {
        return this.myRootModel.getModuleDependencies();
    }

    @NotNull
    public Module[] getModuleDependencies(boolean includeTests) {
        return this.myRootModel.getModuleDependencies(includeTests);
    }

    public boolean isDependsOn(Module module2) {
        return this.myRootModel.isDependsOn(module2);
    }

    @NotNull
    public String[] getDependencyModuleNames() {
        return this.myRootModel.getDependencyModuleNames();
    }

    public <T> T getModuleExtension(Class<T> klass) {
        return this.myRootModel.getModuleExtension(klass);
    }

    public <R> R processOrder(RootPolicy<R> policy, R initialValue) {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.processOrder(policy, initialValue);
    }

    @NotNull
    public OrderEnumerator orderEntries() {
        return new ModuleOrderEnumerator(this.myRootModel, this.myOrderRootsCache);
    }

    public static OrderRootsEnumerator getCachingEnumeratorForType(OrderRootType type, Module module2) {
        return ModuleRootManagerImpl.getEnumeratorForType(type, module2).usingCache();
    }

    @NotNull
    private static OrderRootsEnumerator getEnumeratorForType(OrderRootType type, Module module2) {
        OrderEnumerator base = OrderEnumerator.orderEntries((Module)module2);
        if (type == OrderRootType.CLASSES) {
            return base.exportedOnly().withoutModuleSourceEntries().recursively().classes();
        }
        if (type == OrderRootType.SOURCES) {
            return base.exportedOnly().recursively().sources();
        }
        return base.roots(type);
    }

    @NotNull
    public VirtualFile[] getContentRoots() {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getContentRoots();
    }

    @NotNull
    public String[] getContentRootUrls() {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getContentRootUrls();
    }

    @NotNull
    public String[] getExcludeRootUrls() {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getExcludeRootUrls();
    }

    @NotNull
    public VirtualFile[] getExcludeRoots() {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getExcludeRoots();
    }

    @NotNull
    public String[] getSourceRootUrls() {
        return this.getSourceRootUrls(true);
    }

    @NotNull
    public String[] getSourceRootUrls(boolean includingTests) {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getSourceRootUrls(includingTests);
    }

    @NotNull
    public VirtualFile[] getSourceRoots() {
        return this.getSourceRoots(true);
    }

    @NotNull
    public VirtualFile[] getSourceRoots(boolean includingTests) {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getSourceRoots(includingTests);
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull JpsModuleSourceRootType<?> rootType) {
        return this.myRootModel.getSourceRoots(rootType);
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        return this.myRootModel.getSourceRoots(rootTypes);
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void moduleAdded() {
        this.isModuleAdded = true;
    }

    public void dropCaches() {
        this.myOrderRootsCache.clearCache();
    }

    public ModuleRootManagerState getState() {
        return new ModuleRootManagerState(this.myRootModel);
    }

    public void loadState(ModuleRootManagerState object) {
        this.loadState(object, this.myLoaded || this.isModuleAdded);
        this.myLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadState(ModuleRootManagerState object, boolean throwEvent) {
        AccessToken token = throwEvent ? WriteAction.start() : ReadAction.start();
        try {
            final RootModelImpl newModel = new RootModelImpl(object.getRootModelElement(), this, this.myProjectRootManager, this.myFilePointerManager, throwEvent);
            if (throwEvent) {
                this.makeRootsChange(new Runnable(){

                    @Override
                    public void run() {
                        ModuleRootManagerImpl.doCommit(newModel);
                    }
                });
            } else {
                this.myRootModel.dispose();
                this.myRootModel = newModel;
            }
            assert (!this.myRootModel.isOrderEntryDisposed());
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        finally {
            token.finish();
        }
    }

    public static class ModuleRootManagerState
    implements JDOMExternalizable {
        private RootModelImpl myRootModel;
        private Element myRootModelElement;

        public ModuleRootManagerState() {
        }

        public ModuleRootManagerState(RootModelImpl rootModel) {
            this.myRootModel = rootModel;
        }

        public void readExternal(Element element) {
            this.myRootModelElement = element;
        }

        public void writeExternal(Element element) throws WriteExternalException {
            this.myRootModel.writeExternal(element);
        }

        public Element getRootModelElement() {
            return this.myRootModelElement;
        }
    }
}

