/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.OrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class LibraryOrderEntryBaseImpl
extends OrderEntryBaseImpl
implements LibraryOrSdkOrderEntry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl");
    protected final ProjectRootManagerImpl myProjectRootManagerImpl;
    @NotNull
    protected DependencyScope myScope = DependencyScope.COMPILE;
    @Nullable
    private RootProvider myCurrentlySubscribedRootProvider = null;

    LibraryOrderEntryBaseImpl(@NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        super(rootModel);
        this.myProjectRootManagerImpl = projectRootManager;
    }

    protected final void init() {
        this.updateFromRootProviderAndSubscribe();
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType type) {
        return this.getRootFiles(type);
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType type) {
        LOG.assertTrue(!this.getRootModel().getModule().isDisposed());
        return this.getRootUrls(type);
    }

    public VirtualFile[] getRootFiles(@NotNull OrderRootType type) {
        RootProvider rootProvider = this.getRootProvider();
        return rootProvider != null ? rootProvider.getFiles(type) : VirtualFile.EMPTY_ARRAY;
    }

    @Nullable
    protected abstract RootProvider getRootProvider();

    @NotNull
    public String[] getRootUrls(@NotNull OrderRootType type) {
        RootProvider rootProvider = this.getRootProvider();
        return rootProvider == null ? ArrayUtil.EMPTY_STRING_ARRAY : rootProvider.getUrls(type);
    }

    @NotNull
    public final Module getOwnerModule() {
        return this.getRootModel().getModule();
    }

    protected void updateFromRootProviderAndSubscribe() {
        this.getRootModel().makeExternalChange(new Runnable(){

            @Override
            public void run() {
                LibraryOrderEntryBaseImpl.this.resubscribe(LibraryOrderEntryBaseImpl.this.getRootProvider());
            }
        });
    }

    private void resubscribe(RootProvider wrapper) {
        this.unsubscribe();
        this.subscribe(wrapper);
    }

    private void subscribe(@Nullable RootProvider wrapper) {
        if (wrapper != null) {
            this.myProjectRootManagerImpl.subscribeToRootProvider(this, wrapper);
        }
        this.myCurrentlySubscribedRootProvider = wrapper;
    }

    private void unsubscribe() {
        if (this.myCurrentlySubscribedRootProvider != null) {
            this.myProjectRootManagerImpl.unsubscribeFromRootProvider(this, this.myCurrentlySubscribedRootProvider);
        }
        this.myCurrentlySubscribedRootProvider = null;
    }

    @Override
    public void dispose() {
        this.unsubscribe();
        super.dispose();
    }
}

