/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ProjectExtension;
import com.intellij.openapi.roots.impl.JavaLanguageLevelPusher;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ObjectUtils;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageLevelProjectExtensionImpl
extends LanguageLevelProjectExtension {
    private static final String ASSERT_KEYWORD_ATTR = "assert-keyword";
    private static final String JDK_15_ATTR = "jdk-15";
    private static final String LANGUAGE_LEVEL = "languageLevel";
    private static final String DEFAULT_ATTRIBUTE = "default";
    private final Project myProject;
    private LanguageLevel myLanguageLevel;
    private LanguageLevel myCurrentLevel;

    public LanguageLevelProjectExtensionImpl(Project project2) {
        this.myProject = project2;
        this.setDefault(project2.isDefault() ? Boolean.valueOf(true) : null);
    }

    public static LanguageLevelProjectExtensionImpl getInstanceImpl(Project project2) {
        return (LanguageLevelProjectExtensionImpl)LanguageLevelProjectExtensionImpl.getInstance((Project)project2);
    }

    private void readExternal(Element element) {
        String level = element.getAttributeValue(LANGUAGE_LEVEL);
        this.myLanguageLevel = level == null ? (Registry.is((String)"saving.state.in.new.format.is.allowed", (boolean)false) ? null : LanguageLevelProjectExtensionImpl.migrateFromIdea7(element)) : LanguageLevel.valueOf((String)level);
        String aDefault = element.getAttributeValue(DEFAULT_ATTRIBUTE);
        this.setDefault(aDefault == null ? null : Boolean.valueOf(Boolean.parseBoolean(aDefault)));
    }

    private static LanguageLevel migrateFromIdea7(Element element) {
        boolean assertKeyword = Boolean.valueOf(element.getAttributeValue(ASSERT_KEYWORD_ATTR));
        boolean jdk15 = Boolean.valueOf(element.getAttributeValue(JDK_15_ATTR));
        if (jdk15) {
            return LanguageLevel.JDK_1_5;
        }
        if (assertKeyword) {
            return LanguageLevel.JDK_1_4;
        }
        return LanguageLevel.JDK_1_3;
    }

    private void writeExternal(Element element) {
        Boolean aBoolean;
        if (this.myLanguageLevel != null) {
            element.setAttribute(LANGUAGE_LEVEL, this.myLanguageLevel.name());
        }
        if ((aBoolean = this.getDefault()) != null) {
            element.setAttribute(DEFAULT_ATTRIBUTE, Boolean.toString(aBoolean));
        }
        if (!Registry.is((String)"saving.state.in.new.format.is.allowed", (boolean)false)) {
            this.writeAttributesForIdea7(element);
        }
    }

    private void writeAttributesForIdea7(Element element) {
        boolean is14 = LanguageLevel.JDK_1_4.equals((Object)this.myLanguageLevel);
        boolean is15 = this.myLanguageLevel != null && this.myLanguageLevel.compareTo((Enum)LanguageLevel.JDK_1_5) >= 0;
        element.setAttribute(ASSERT_KEYWORD_ATTR, Boolean.toString(is14 || is15));
        element.setAttribute(JDK_15_ATTR, Boolean.toString(is15));
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        return this.getLanguageLevelOrDefault();
    }

    @NotNull
    private LanguageLevel getLanguageLevelOrDefault() {
        return (LanguageLevel)ObjectUtils.chooseNotNull((Object)this.myLanguageLevel, (Object)LanguageLevel.HIGHEST);
    }

    public void setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (this.myLanguageLevel != languageLevel) {
            this.myLanguageLevel = languageLevel;
            this.languageLevelsChanged();
        }
    }

    public void languageLevelsChanged() {
        if (!this.myProject.isDefault()) {
            JavaLanguageLevelPusher.pushLanguageLevel(this.myProject);
        }
    }

    private void projectSdkChanged(@Nullable Sdk sdk) {
        JavaSdkVersion version;
        if (this.isDefault() && sdk != null && (version = JavaSdk.getInstance().getVersion(sdk)) != null) {
            this.setLanguageLevel(version.getMaxLanguageLevel());
        }
    }

    public void setCurrentLevel(LanguageLevel level) {
        this.myCurrentLevel = level;
    }

    public LanguageLevel getCurrentLevel() {
        return this.myCurrentLevel;
    }

    public static class MyProjectExtension
    extends ProjectExtension {
        private final LanguageLevelProjectExtensionImpl myInstance;

        public MyProjectExtension(Project project2) {
            this.myInstance = (LanguageLevelProjectExtensionImpl)LanguageLevelProjectExtension.getInstance((Project)project2);
        }

        @Override
        public void readExternal(@NotNull Element element) {
            this.myInstance.readExternal(element);
        }

        @Override
        public void writeExternal(@NotNull Element element) {
            this.myInstance.writeExternal(element);
        }

        @Override
        public void projectSdkChanged(@Nullable Sdk sdk) {
            this.myInstance.projectSdkChanged(sdk);
        }
    }
}

