/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.JavaProjectModelModifier;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.pom.java.LanguageLevel;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public class JavaProjectModelModificationServiceImpl
extends JavaProjectModelModificationService {
    private final Project myProject;

    public JavaProjectModelModificationServiceImpl(Project project2) {
        this.myProject = project2;
    }

    @Override
    public Promise<Void> addDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope) {
        for (JavaProjectModelModifier modifier : this.getModelModifiers()) {
            Promise<Void> promise2 = modifier.addModuleDependency(from, to, scope);
            if (promise2 == null) continue;
            return promise2;
        }
        return Promise.REJECTED;
    }

    @Override
    public Promise<Void> addDependency(@NotNull Collection<Module> from, @NotNull ExternalLibraryDescriptor libraryDescriptor, @NotNull DependencyScope scope) {
        for (JavaProjectModelModifier modifier : this.getModelModifiers()) {
            Promise<Void> promise2 = modifier.addExternalLibraryDependency(from, libraryDescriptor, scope);
            if (promise2 == null) continue;
            return promise2;
        }
        return Promise.REJECTED;
    }

    @Override
    public Promise<Void> addDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope) {
        for (JavaProjectModelModifier modifier : this.getModelModifiers()) {
            Promise<Void> promise2 = modifier.addLibraryDependency(from, library, scope);
            if (promise2 == null) continue;
            return promise2;
        }
        return Promise.REJECTED;
    }

    @Override
    public Promise<Void> changeLanguageLevel(@NotNull Module module2, @NotNull LanguageLevel languageLevel) {
        for (JavaProjectModelModifier modifier : this.getModelModifiers()) {
            Promise<Void> promise2 = modifier.changeLanguageLevel(module2, languageLevel);
            if (promise2 == null) continue;
            return promise2;
        }
        return Promise.REJECTED;
    }

    @NotNull
    private JavaProjectModelModifier[] getModelModifiers() {
        return (JavaProjectModelModifier[])JavaProjectModelModifier.EP_NAME.getExtensions((AreaInstance)this.myProject);
    }
}

