/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public abstract class FileIndexBase
implements FileIndex {
    protected final FileTypeRegistry myFileTypeRegistry;
    protected final DirectoryIndex myDirectoryIndex;

    public FileIndexBase(@NotNull DirectoryIndex directoryIndex, @NotNull FileTypeRegistry fileTypeManager, @NotNull Project project2) {
        this.myDirectoryIndex = directoryIndex;
        this.myFileTypeRegistry = fileTypeManager;
    }

    @NotNull
    protected DirectoryInfo getInfoForFileOrDirectory(@NotNull VirtualFile file2) {
        return this.myDirectoryIndex.getInfoForFile(file2);
    }

    public boolean isContentSourceFile(@NotNull VirtualFile file2) {
        return !file2.isDirectory() && !this.myFileTypeRegistry.isFileIgnored(file2) && this.isInSourceContent(file2);
    }
}

