/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.NonProjectDirectoryInfo;
import com.intellij.openapi.roots.impl.RootIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Query;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class DirectoryIndexImpl
extends DirectoryIndex {
    private static final Logger LOG = Logger.getInstance(DirectoryIndexImpl.class);
    private final Project myProject;
    private final MessageBusConnection myConnection;
    private volatile boolean myDisposed;
    private volatile RootIndex myRootIndex;

    public DirectoryIndexImpl(@NotNull Project project2) {
        this.myProject = project2;
        this.myConnection = project2.getMessageBus().connect((Disposable)project2);
        this.subscribeToFileChanges();
        Disposer.register((Disposable)project2, (Disposable)new Disposable(){

            public void dispose() {
                DirectoryIndexImpl.this.myDisposed = true;
                DirectoryIndexImpl.this.myRootIndex = null;
            }
        });
    }

    protected void subscribeToFileChanges() {
        this.myConnection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener.Adapter(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                DirectoryIndexImpl.this.myRootIndex = null;
            }
        });
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                DirectoryIndexImpl.this.myRootIndex = null;
            }
        });
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                RootIndex rootIndex = DirectoryIndexImpl.this.myRootIndex;
                if (rootIndex != null && rootIndex.resetOnEvents(events)) {
                    DirectoryIndexImpl.this.myRootIndex = null;
                }
            }
        });
    }

    protected void dispatchPendingEvents() {
        this.myConnection.deliverImmediately();
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        return this.getRootIndex().getDirectoriesByPackageName(packageName, includeLibrarySources);
    }

    @NotNull
    private RootIndex getRootIndex() {
        RootIndex rootIndex = this.myRootIndex;
        if (rootIndex == null) {
            this.myRootIndex = rootIndex = new RootIndex(this.myProject, this.createRootInfoCache());
        }
        return rootIndex;
    }

    protected RootIndex.InfoCache createRootInfoCache() {
        return new RootIndex.InfoCache(){
            private final ConcurrentIntObjectMap<DirectoryInfo> myInfoCache = ContainerUtil.createConcurrentIntObjectMap();

            @Override
            public void cacheInfo(@NotNull VirtualFile dir, @NotNull DirectoryInfo info) {
                this.myInfoCache.put(((NewVirtualFile)dir).getId(), (Object)info);
            }

            @Override
            public DirectoryInfo getCachedInfo(@NotNull VirtualFile dir) {
                return (DirectoryInfo)this.myInfoCache.get(((NewVirtualFile)dir).getId());
            }
        };
    }

    @Override
    public DirectoryInfo getInfoForDirectory(@NotNull VirtualFile dir) {
        DirectoryInfo info = this.getInfoForFile(dir);
        return info.isInProject() ? info : null;
    }

    @Override
    @NotNull
    public DirectoryInfo getInfoForFile(@NotNull VirtualFile file2) {
        this.checkAvailability();
        this.dispatchPendingEvents();
        if (!(file2 instanceof NewVirtualFile)) {
            return NonProjectDirectoryInfo.NOT_SUPPORTED_VIRTUAL_FILE_IMPLEMENTATION;
        }
        return this.getRootIndex().getInfoForFile(file2);
    }

    @Override
    @Nullable
    public JpsModuleSourceRootType<?> getSourceRootType(@NotNull DirectoryInfo info) {
        if (info.isInModuleSource()) {
            return this.getRootIndex().getSourceRootType(info);
        }
        return null;
    }

    @Override
    public String getPackageName(@NotNull VirtualFile dir) {
        this.checkAvailability();
        if (!(dir instanceof NewVirtualFile)) {
            return null;
        }
        return this.getRootIndex().getPackageName(dir);
    }

    @Override
    @NotNull
    public List<OrderEntry> getOrderEntries(@NotNull DirectoryInfo info) {
        this.checkAvailability();
        return this.getRootIndex().getOrderEntries(info);
    }

    void assertConsistency(DirectoryInfo info) {
        List<OrderEntry> entries = this.getOrderEntries(info);
        for (int i = 1; i < entries.size(); ++i) {
            assert (RootIndex.BY_OWNER_MODULE.compare(entries.get(i - 1), entries.get(i)) <= 0);
        }
    }

    private void checkAvailability() {
        if (this.myDisposed) {
            ProgressManager.checkCanceled();
            LOG.error("Directory index is already disposed for " + this.myProject);
        }
    }
}

