/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.projectRoots.ui.PathEditor;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkEditor
implements Configurable,
Place.Navigator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.ui.SdkEditor");
    @NonNls
    private static final String SDK_TAB = "sdkTab";
    private Sdk mySdk;
    private final Map<OrderRootType, SdkPathEditor> myPathEditors = new HashMap<OrderRootType, SdkPathEditor>();
    private TextFieldWithBrowseButton myHomeComponent;
    private final Map<SdkType, AdditionalDataConfigurable> myAdditionalDataConfigurables = new HashMap<SdkType, AdditionalDataConfigurable>();
    private final Map<AdditionalDataConfigurable, JComponent> myAdditionalDataComponents = new HashMap<AdditionalDataConfigurable, JComponent>();
    private JPanel myAdditionalDataPanel;
    private final SdkModificator myEditedSdkModificator = new EditedSdkModificator();
    private JPanel myMainPanel;
    private TabbedPaneWrapper myTabbedPane;
    private final SdkModel mySdkModel;
    private JLabel myHomeFieldLabel;
    private String myVersionString;
    private String myInitialName;
    private String myInitialPath;
    private final History myHistory;
    private final Disposable myDisposable = Disposer.newDisposable();

    public SdkEditor(SdkModel sdkModel, History history, ProjectJdkImpl sdk) {
        this.mySdkModel = sdkModel;
        this.myHistory = history;
        this.mySdk = sdk;
        this.createMainPanel();
        this.initSdk(sdk);
    }

    private void initSdk(Sdk sdk) {
        this.mySdk = sdk;
        if (this.mySdk != null) {
            this.myInitialName = this.mySdk.getName();
            this.myInitialPath = this.mySdk.getHomePath();
        } else {
            this.myInitialName = "";
            this.myInitialPath = "";
        }
        AdditionalDataConfigurable additionalDataConfigurable = this.getAdditionalDataConfigurable();
        if (additionalDataConfigurable != null) {
            additionalDataConfigurable.setSdk(sdk);
        }
        if (this.myMainPanel != null) {
            this.reset();
        }
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"sdk.configure.editor.title", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    private void createMainPanel() {
        this.myMainPanel = new JPanel(new GridBagLayout());
        this.myTabbedPane = new TabbedPaneWrapper(this.myDisposable);
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            SdkPathEditor pathEditor;
            if (this.mySdk != null && !this.showTabForType(type) || (pathEditor = ((OrderRootTypeUIFactory)OrderRootTypeUIFactory.FACTORY.getByKey((Object)type)).createPathEditor(this.mySdk)) == null) continue;
            pathEditor.setAddBaseDir(this.mySdk.getHomeDirectory());
            this.myTabbedPane.addTab(pathEditor.getDisplayName(), pathEditor.createComponent());
            this.myPathEditors.put(type, pathEditor);
        }
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SdkEditor.this.myHistory.pushQueryPlace();
            }
        });
        this.myHomeComponent = this.createHomeComponent();
        this.myHomeComponent.getTextField().setEditable(false);
        this.myHomeFieldLabel = new JLabel(this.getHomeFieldLabelValue());
        int leftInset = 10;
        int rightInset = 10;
        this.myMainPanel.add((Component)this.myHomeFieldLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 2, 2), 0, 0));
        this.myMainPanel.add((Component)this.myHomeComponent, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 10), 0, 0));
        this.myAdditionalDataPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add((Component)this.myAdditionalDataPanel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 10, 1, new Insets(2, 10, 0, 10), 0, 0));
        this.myMainPanel.add((Component)this.myTabbedPane.getComponent(), new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
    }

    protected TextFieldWithBrowseButton createHomeComponent() {
        return new TextFieldWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SdkEditor.this.doSelectHomePath();
            }
        });
    }

    protected boolean showTabForType(@NotNull OrderRootType type) {
        return ((SdkType)this.mySdk.getSdkType()).isRootTypeApplicable(type);
    }

    private String getHomeFieldLabelValue() {
        if (this.mySdk != null) {
            return ((SdkType)this.mySdk.getSdkType()).getHomeFieldLabel();
        }
        return ProjectBundle.message((String)"sdk.configure.general.home.path", (Object[])new Object[0]);
    }

    public boolean isModified() {
        boolean isModified = !Comparing.equal((String)(this.mySdk == null ? null : this.mySdk.getName()), (String)this.myInitialName);
        isModified = isModified || !Comparing.equal((String)FileUtil.toSystemIndependentName((String)this.getHomeValue()), (String)FileUtil.toSystemIndependentName((String)this.myInitialPath));
        for (PathEditor pathEditor : this.myPathEditors.values()) {
            isModified = isModified || pathEditor.isModified();
        }
        AdditionalDataConfigurable configurable = this.getAdditionalDataConfigurable();
        if (configurable != null) {
            isModified = isModified || configurable.isModified();
        }
        return isModified;
    }

    public void apply() throws ConfigurationException {
        if (!Comparing.equal((String)this.myInitialName, (String)(this.mySdk == null ? "" : this.mySdk.getName())) && (this.mySdk == null || this.mySdk.getName().isEmpty())) {
            throw new ConfigurationException(ProjectBundle.message((String)"sdk.list.name.required.error", (Object[])new Object[0]));
        }
        if (this.mySdk != null) {
            this.myInitialName = this.mySdk.getName();
            this.myInitialPath = this.mySdk.getHomePath();
            final SdkModificator sdkModificator = this.mySdk.getSdkModificator();
            sdkModificator.setHomePath(this.getHomeValue().replace(File.separatorChar, '/'));
            for (SdkPathEditor pathEditor : this.myPathEditors.values()) {
                pathEditor.apply(sdkModificator);
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    sdkModificator.commitChanges();
                }
            });
            AdditionalDataConfigurable configurable = this.getAdditionalDataConfigurable();
            if (configurable != null) {
                configurable.apply();
            }
        }
    }

    public void reset() {
        if (this.mySdk == null) {
            this.setHomePathValue("");
            for (SdkPathEditor pathEditor : this.myPathEditors.values()) {
                pathEditor.reset(null);
            }
        } else {
            SdkModificator sdkModificator = this.mySdk.getSdkModificator();
            for (OrderRootType type : this.myPathEditors.keySet()) {
                this.myPathEditors.get(type).reset(sdkModificator);
            }
            sdkModificator.commitChanges();
            this.setHomePathValue(this.mySdk.getHomePath().replace('/', File.separatorChar));
        }
        this.myVersionString = null;
        this.myHomeFieldLabel.setText(this.getHomeFieldLabelValue());
        this.updateAdditionalDataComponent();
        AdditionalDataConfigurable configurable = this.getAdditionalDataConfigurable();
        if (configurable != null) {
            configurable.reset();
        }
        this.myHomeComponent.setEnabled(this.mySdk != null);
        for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
            this.myTabbedPane.setEnabledAt(i, this.mySdk != null);
        }
    }

    public void disposeUIResources() {
        for (SdkType sdkType : this.myAdditionalDataConfigurables.keySet()) {
            AdditionalDataConfigurable configurable = this.myAdditionalDataConfigurables.get(sdkType);
            configurable.disposeUIResources();
        }
        this.myAdditionalDataConfigurables.clear();
        this.myAdditionalDataComponents.clear();
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private String getHomeValue() {
        return this.myHomeComponent.getText().trim();
    }

    private void clearAllPaths() {
        for (PathEditor pathEditor : this.myPathEditors.values()) {
            pathEditor.clearList();
        }
    }

    private void setHomePathValue(String absolutePath) {
        Color fg;
        this.myHomeComponent.setText(absolutePath);
        if (absolutePath != null && !absolutePath.isEmpty()) {
            File homeDir = new File(absolutePath);
            boolean homeMustBeDirectory = this.mySdk == null || ((SdkType)this.mySdk.getSdkType()).getHomeChooserDescriptor().isChooseFolders();
            fg = homeDir.exists() && homeDir.isDirectory() == homeMustBeDirectory ? UIUtil.getFieldForegroundColor() : PathEditor.INVALID_COLOR;
        } else {
            fg = UIUtil.getFieldForegroundColor();
        }
        this.myHomeComponent.getTextField().setForeground(fg);
    }

    private void doSelectHomePath() {
        final SdkType sdkType = (SdkType)this.mySdk.getSdkType();
        SdkConfigurationUtil.selectSdkHome(sdkType, new Consumer<String>(){

            public void consume(String path) {
                SdkEditor.this.doSetHomePath(path, sdkType);
            }
        });
    }

    private void doSetHomePath(String homePath, SdkType sdkType) {
        if (homePath == null) {
            return;
        }
        this.setHomePathValue(homePath.replace('/', File.separatorChar));
        String newSdkName = this.suggestSdkName(homePath);
        ((ProjectJdkImpl)this.mySdk).setName(newSdkName);
        try {
            Sdk dummySdk = (Sdk)this.mySdk.clone();
            SdkModificator sdkModificator = dummySdk.getSdkModificator();
            sdkModificator.setHomePath(homePath);
            sdkModificator.removeAllRoots();
            sdkModificator.commitChanges();
            sdkType.setupSdkPaths(dummySdk, this.mySdkModel);
            this.clearAllPaths();
            this.myVersionString = dummySdk.getVersionString();
            if (this.myVersionString == null) {
                Messages.showMessageDialog((String)ProjectBundle.message((String)"sdk.java.corrupt.error", (Object[])new Object[]{homePath}), (String)ProjectBundle.message((String)"sdk.java.corrupt.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            }
            sdkModificator = dummySdk.getSdkModificator();
            for (OrderRootType type : this.myPathEditors.keySet()) {
                SdkPathEditor pathEditor = this.myPathEditors.get(type);
                pathEditor.setAddBaseDir(dummySdk.getHomeDirectory());
                pathEditor.addPaths(sdkModificator.getRoots(type));
            }
            this.mySdkModel.getMulticaster().sdkHomeSelected(dummySdk, homePath);
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
        }
    }

    private String suggestSdkName(String homePath) {
        Sdk[] sdks;
        String suggestedName;
        String currentName = this.mySdk.getName();
        if (Comparing.equal((String)currentName, (String)(suggestedName = ((SdkType)this.mySdk.getSdkType()).suggestSdkName(currentName, homePath)))) {
            return currentName;
        }
        String newSdkName = suggestedName;
        HashSet<String> allNames = new HashSet<String>();
        for (Sdk sdk : sdks = this.mySdkModel.getSdks()) {
            allNames.add(sdk.getName());
        }
        int i = 0;
        while (allNames.contains(newSdkName)) {
            newSdkName = suggestedName + " (" + ++i + ")";
        }
        return newSdkName;
    }

    private void updateAdditionalDataComponent() {
        this.myAdditionalDataPanel.removeAll();
        AdditionalDataConfigurable configurable = this.getAdditionalDataConfigurable();
        if (configurable != null) {
            JComponent component = this.myAdditionalDataComponents.get(configurable);
            if (component == null) {
                component = configurable.createComponent();
                this.myAdditionalDataComponents.put(configurable, component);
            }
            this.myAdditionalDataPanel.add((Component)component, "Center");
        }
    }

    @Nullable
    private AdditionalDataConfigurable getAdditionalDataConfigurable() {
        if (this.mySdk == null) {
            return null;
        }
        return this.initAdditionalDataConfigurable(this.mySdk);
    }

    @Nullable
    private AdditionalDataConfigurable initAdditionalDataConfigurable(Sdk sdk) {
        SdkType sdkType = (SdkType)sdk.getSdkType();
        AdditionalDataConfigurable configurable = this.myAdditionalDataConfigurables.get(sdkType);
        if (configurable == null && (configurable = sdkType.createAdditionalDataConfigurable(this.mySdkModel, this.myEditedSdkModificator)) != null) {
            this.myAdditionalDataConfigurables.put(sdkType, configurable);
        }
        return configurable;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        if (place == null) {
            return ActionCallback.DONE;
        }
        this.myTabbedPane.setSelectedTitle((String)place.getPath(SDK_TAB));
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        place.putPath(SDK_TAB, (Object)this.myTabbedPane.getSelectedTitle());
    }

    public void setHistory(History history) {
    }

    private class EditedSdkModificator
    implements SdkModificator {
        private EditedSdkModificator() {
        }

        public String getName() {
            return SdkEditor.this.mySdk.getName();
        }

        public void setName(String name) {
            ((ProjectJdkImpl)SdkEditor.this.mySdk).setName(name);
        }

        public String getHomePath() {
            return SdkEditor.this.getHomeValue();
        }

        public void setHomePath(String path) {
            SdkEditor.this.doSetHomePath(path, (SdkType)SdkEditor.this.mySdk.getSdkType());
        }

        public String getVersionString() {
            return SdkEditor.this.myVersionString != null ? SdkEditor.this.myVersionString : SdkEditor.this.mySdk.getVersionString();
        }

        public void setVersionString(String versionString) {
            throw new UnsupportedOperationException();
        }

        public SdkAdditionalData getSdkAdditionalData() {
            return SdkEditor.this.mySdk.getSdkAdditionalData();
        }

        public void setSdkAdditionalData(SdkAdditionalData data) {
            throw new UnsupportedOperationException();
        }

        public VirtualFile[] getRoots(OrderRootType rootType) {
            PathEditor editor = (PathEditor)SdkEditor.this.myPathEditors.get(rootType);
            if (editor == null) {
                throw new IllegalStateException("no editor for root type " + rootType);
            }
            return editor.getRoots();
        }

        public void addRoot(VirtualFile root, OrderRootType rootType) {
            ((SdkPathEditor)SdkEditor.this.myPathEditors.get(rootType)).addPaths(new VirtualFile[]{root});
        }

        public void removeRoot(VirtualFile root, OrderRootType rootType) {
            ((SdkPathEditor)SdkEditor.this.myPathEditors.get(rootType)).removePaths(new VirtualFile[]{root});
        }

        public void removeRoots(OrderRootType rootType) {
            ((SdkPathEditor)SdkEditor.this.myPathEditors.get(rootType)).clearList();
        }

        public void removeAllRoots() {
            for (PathEditor editor : SdkEditor.this.myPathEditors.values()) {
                editor.clearList();
            }
        }

        public void commitChanges() {
        }

        public boolean isWritable() {
            return true;
        }
    }
}

