/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MockJdkWrapper
implements Sdk {
    private final String myHomePath;
    private final Sdk myDelegate;

    public MockJdkWrapper(String homePath, @NotNull Sdk delegate) {
        this.myHomePath = homePath;
        this.myDelegate = delegate;
    }

    public VirtualFile getHomeDirectory() {
        return LocalFileSystem.getInstance().findFileByIoFile(new File(this.getHomePath()));
    }

    public String getHomePath() {
        String homePath = FileUtil.toSystemDependentName((String)(this.myHomePath == null ? this.myDelegate.getHomePath() : this.myHomePath));
        return StringUtil.trimEnd((String)homePath, (String)File.separator);
    }

    @NotNull
    public SdkTypeId getSdkType() {
        return this.myDelegate.getSdkType();
    }

    @NotNull
    public String getName() {
        return this.myDelegate.getName();
    }

    public String getVersionString() {
        return this.myDelegate.getVersionString();
    }

    @NotNull
    public RootProvider getRootProvider() {
        return this.myDelegate.getRootProvider();
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myDelegate.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myDelegate.putUserData(key, value);
    }

    @NotNull
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public SdkAdditionalData getSdkAdditionalData() {
        return null;
    }

    @NotNull
    public SdkModificator getSdkModificator() {
        return this.myDelegate.getSdkModificator();
    }

    public Sdk getDelegate() {
        return this.myDelegate;
    }
}

