/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class DependentSdkType
extends SdkType {
    public DependentSdkType(@NonNls String name) {
        super(name);
    }

    protected boolean checkDependency(SdkModel sdkModel) {
        return ContainerUtil.find((Object[])sdkModel.getSdks(), (Condition)new Condition<Sdk>(){

            public boolean value(Sdk sdk) {
                return DependentSdkType.this.isValidDependency(sdk);
            }
        }) != null;
    }

    protected abstract boolean isValidDependency(Sdk var1);

    public abstract String getUnsatisfiedDependencyMessage();

    public boolean supportsCustomCreateUI() {
        return true;
    }

    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @NotNull Consumer<Sdk> sdkCreatedCallback) {
        if (!this.checkDependency(sdkModel)) {
            if (Messages.showOkCancelDialog((Component)parentComponent, (String)this.getUnsatisfiedDependencyMessage(), (String)"Cannot Create SDK", (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
            if (this.fixDependency(sdkModel, sdkCreatedCallback) == null) {
                return;
            }
        }
        DependentSdkType.createSdkOfType(sdkModel, this, sdkCreatedCallback);
    }

    protected abstract SdkType getDependencyType();

    protected Sdk fixDependency(SdkModel sdkModel, Consumer<Sdk> sdkCreatedCallback) {
        return DependentSdkType.createSdkOfType(sdkModel, this.getDependencyType(), sdkCreatedCallback);
    }

    protected static Sdk createSdkOfType(final SdkModel sdkModel, final SdkType sdkType, final Consumer<Sdk> sdkCreatedCallback) {
        final Ref result = new Ref(null);
        SdkConfigurationUtil.selectSdkHome(sdkType, new Consumer<String>(){

            public void consume(String home) {
                String newSdkName = SdkConfigurationUtil.createUniqueSdkName(sdkType, home, Arrays.asList(sdkModel.getSdks()));
                ProjectJdkImpl newJdk = new ProjectJdkImpl(newSdkName, (SdkTypeId)sdkType);
                newJdk.setHomePath(home);
                sdkCreatedCallback.consume((Object)newJdk);
                result.set((Object)newJdk);
            }
        });
        return (Sdk)result.get();
    }
}

