/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.CommonBundle;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectReloadState;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.DefaultProject;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectManagerImpl
extends ProjectManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ProjectManagerImpl.class);
    private static final Key<List<ProjectManagerListener>> LISTENERS_IN_PROJECT_KEY = Key.create((String)"LISTENERS_IN_PROJECT_KEY");
    private ProjectImpl myDefaultProject;
    private Project[] myOpenProjects = new Project[0];
    private final Object lock = new Object();
    private final List<ProjectManagerListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final ProgressManager myProgressManager;
    private volatile boolean myDefaultProjectWasDisposed;
    public static int TEST_PROJECTS_CREATED;
    private static final boolean LOG_PROJECT_LEAKAGE_IN_TESTS = false;
    private static final int MAX_LEAKY_PROJECTS = 42;
    private final Map<Project, String> myProjects = new WeakHashMap<Project, String>();

    @NotNull
    private static List<ProjectManagerListener> getListeners(@NotNull Project project2) {
        List array = (List)project2.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (array == null) {
            return Collections.emptyList();
        }
        return array;
    }

    public ProjectManagerImpl(ProgressManager progressManager) {
        this.myProgressManager = progressManager;
        final ProjectManagerListener busPublisher = (ProjectManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC);
        this.addProjectManagerListener(new ProjectManagerListener(){

            public void projectOpened(Project project2) {
                busPublisher.projectOpened(project2);
                for (ProjectManagerListener listener2 : ProjectManagerImpl.getListeners(project2)) {
                    listener2.projectOpened(project2);
                }
            }

            public void projectClosed(Project project2) {
                busPublisher.projectClosed(project2);
                for (ProjectManagerListener listener2 : ProjectManagerImpl.getListeners(project2)) {
                    listener2.projectClosed(project2);
                }
                ZipHandler.clearFileAccessorCache();
            }

            public boolean canCloseProject(Project project2) {
                for (ProjectManagerListener listener2 : ProjectManagerImpl.getListeners(project2)) {
                    if (listener2.canCloseProject(project2)) continue;
                    return false;
                }
                return true;
            }

            public void projectClosing(Project project2) {
                busPublisher.projectClosing(project2);
                for (ProjectManagerListener listener2 : ProjectManagerImpl.getListeners(project2)) {
                    listener2.projectClosing(project2);
                }
            }
        });
    }

    public void dispose() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.myDefaultProject != null) {
            Disposer.dispose((Disposable)this.myDefaultProject);
            this.myDefaultProject = null;
            this.myDefaultProjectWasDisposed = true;
        }
    }

    @Override
    @Nullable
    public Project newProject(@Nullable String projectName, @NotNull String filePath, boolean useDefaultProjectSettings, boolean isDummy) {
        File projectFile;
        filePath = ProjectManagerImpl.toCanonicalName(filePath);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ++TEST_PROJECTS_CREATED;
        }
        if ((projectFile = new File(filePath)).isFile()) {
            FileUtil.delete((File)projectFile);
        } else {
            File[] files = new File(projectFile, ".idea").listFiles();
            if (files != null) {
                for (File file2 : files) {
                    FileUtil.delete((File)file2);
                }
            }
        }
        ProjectImpl project2 = this.createProject(projectName, filePath, false);
        try {
            this.initProject(project2, useDefaultProjectSettings ? this.getDefaultProject() : null);
            return project2;
        }
        catch (Throwable t) {
            LOG.info(t);
            Messages.showErrorDialog((String)ProjectManagerImpl.message(t), (String)ProjectBundle.message((String)"project.load.default.error", (Object[])new Object[0]));
            return null;
        }
    }

    @NonNls
    @NotNull
    private static String message(@NotNull Throwable e) {
        String message = e.getMessage();
        if (message != null) {
            return message;
        }
        message = e.getLocalizedMessage();
        if (message != null) {
            return message;
        }
        message = e.toString();
        Throwable cause = e.getCause();
        if (cause != null) {
            String causeMessage = ProjectManagerImpl.message(cause);
            return message + " (cause: " + causeMessage + ")";
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProject(@NotNull ProjectImpl project2, @Nullable Project template) {
        ProgressIndicator indicator = this.myProgressManager.getProgressIndicator();
        if (indicator != null && !project2.isDefault()) {
            indicator.setText(ProjectBundle.message((String)"loading.components.for", (Object[])new Object[]{project2.getName()}));
            indicator.setIndeterminate(true);
        }
        ((ProjectLifecycleListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).beforeProjectLoaded((Project)project2);
        boolean succeed = false;
        try {
            if (template != null) {
                project2.getStateStore().loadProjectFromTemplate(template);
            }
            project2.init();
            succeed = true;
        }
        finally {
            if (!succeed) {
                ProjectManagerImpl.scheduleDispose(project2);
            }
        }
    }

    private ProjectImpl createProject(@Nullable String projectName, @NotNull String filePath, boolean isDefault) {
        if (isDefault) {
            return new DefaultProject(this, "");
        }
        return new ProjectImpl(this, FileUtilRt.toSystemIndependentName((String)filePath), projectName);
    }

    private static void scheduleDispose(final @NotNull ProjectImpl project2) {
        if (project2.isDefault()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        if (!project2.isDisposed()) {
                            Disposer.dispose((Disposable)project2);
                        }
                    }
                });
            }
        });
    }

    @Override
    @Nullable
    public Project loadProject(@NotNull String filePath) throws IOException {
        try {
            ProjectImpl project2 = this.createProject(null, new File(filePath).getAbsolutePath(), false);
            this.initProject(project2, null);
            return project2;
        }
        catch (Throwable t) {
            LOG.info(t);
            throw new IOException(t);
        }
    }

    @NotNull
    private static String toCanonicalName(@NotNull String filePath) {
        try {
            return FileUtil.resolveShortWindowsName((String)filePath);
        }
        catch (IOException iOException) {
            return filePath;
        }
    }

    public synchronized boolean isDefaultProjectInitialized() {
        return this.myDefaultProject != null;
    }

    @NotNull
    public synchronized Project getDefaultProject() {
        LOG.assertTrue(!this.myDefaultProjectWasDisposed, (Object)"Default project has been already disposed!");
        if (this.myDefaultProject == null) {
            ProgressManager.getInstance().executeNonCancelableSection(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProjectManagerImpl.this.myDefaultProject = ProjectManagerImpl.this.createProject(null, "", true);
                        ProjectManagerImpl.this.initProject(ProjectManagerImpl.this.myDefaultProject, null);
                    }
                    catch (Throwable t) {
                        PluginManager.processException(t);
                    }
                }
            });
        }
        return this.myDefaultProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Project[] getOpenProjects() {
        Object object = this.lock;
        synchronized (object) {
            return this.myOpenProjects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProjectOpened(Project project2) {
        Object object = this.lock;
        synchronized (object) {
            return ArrayUtil.contains((Object)project2, (Object[])this.myOpenProjects);
        }
    }

    @Override
    public boolean openProject(final @NotNull Project project2) {
        if (ProjectManagerImpl.isLight(project2)) {
            ((ProjectImpl)project2).setTemporarilyDisposed(false);
            boolean isInitialized = StartupManagerEx.getInstanceEx(project2).startupActivityPassed();
            if (isInitialized) {
                this.addToOpened(project2);
                return true;
            }
        }
        if (!this.addToOpened(project2)) {
            return false;
        }
        this.fireProjectOpened(project2);
        DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

            @Override
            public void run() {
                DumbService.getInstance((Project)project2).queueTask(new DumbModeTask(){

                    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                        ProjectManagerImpl.waitForFileWatcher(indicator);
                    }

                    public String toString() {
                        return "wait for file watcher";
                    }
                });
            }
        });
        final StartupManagerImpl startupManager = (StartupManagerImpl)StartupManager.getInstance((Project)project2);
        boolean ok = this.myProgressManager.runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                startupManager.runStartupActivities();
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        startupManager.startCacheUpdate();
                    }
                });
                startupManager.runPostStartupActivitiesFromExtensions();
                GuiUtils.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!project2.isDisposed()) {
                            startupManager.runPostStartupActivities();
                            Application application = ApplicationManager.getApplication();
                            if (!application.isHeadlessEnvironment() && !application.isUnitTestMode()) {
                                StorageUtil.checkUnknownMacros(project2, true);
                            }
                        }
                    }
                }, (ModalityState)ModalityState.NON_MODAL);
            }
        }, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), ProjectManagerImpl.canCancelProjectLoading(), project2);
        if (!ok) {
            this.closeProject(project2, false, false, true);
            ProjectManagerImpl.notifyProjectOpenFailed();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToOpened(@NotNull Project project2) {
        assert (!project2.isDisposed()) : "Must not open already disposed project";
        Object object = this.lock;
        synchronized (object) {
            if (this.isProjectOpened(project2)) {
                return false;
            }
            this.myOpenProjects = (Project[])ArrayUtil.append((Object[])this.myOpenProjects, (Object)project2);
            ProjectCoreUtil.theProject = this.myOpenProjects.length == 1 ? project2 : null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Collection<Project> removeFromOpened(@NotNull Project project2) {
        Object object = this.lock;
        synchronized (object) {
            this.myOpenProjects = (Project[])ArrayUtil.remove((Object[])this.myOpenProjects, (Object)project2);
            ProjectCoreUtil.theProject = this.myOpenProjects.length == 1 ? this.myOpenProjects[0] : null;
            return Arrays.asList(this.myOpenProjects);
        }
    }

    private static boolean canCancelProjectLoading() {
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        return !(indicator instanceof NonCancelableSection);
    }

    private static void waitForFileWatcher(@NotNull ProgressIndicator indicator) {
        LocalFileSystem fs = LocalFileSystem.getInstance();
        if (!(fs instanceof LocalFileSystemImpl)) {
            return;
        }
        FileWatcher watcher = ((LocalFileSystemImpl)fs).getFileWatcher();
        if (!watcher.isOperational() || !watcher.isSettingRoots()) {
            return;
        }
        LOG.info("FW/roots waiting started");
        indicator.setIndeterminate(true);
        indicator.setText(ProjectBundle.message((String)"project.load.waiting.watcher", (Object[])new Object[0]));
        if (indicator instanceof ProgressWindow) {
            ((ProgressWindow)indicator).setCancelButtonText(CommonBundle.message((String)"button.skip", (Object[])new Object[0]));
        }
        while (watcher.isSettingRoots() && !indicator.isCanceled()) {
            TimeoutUtil.sleep((long)10L);
        }
        LOG.info("FW/roots waiting finished");
    }

    public Project loadAndOpenProject(@NotNull String filePath) throws IOException {
        final Project project2 = this.convertAndLoadProject(filePath);
        if (project2 == null) {
            WelcomeFrame.showIfNoProjectOpened();
            return null;
        }
        if (!this.openProject(project2)) {
            WelcomeFrame.showIfNoProjectOpened();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    Disposer.dispose((Disposable)project2);
                }
            });
        }
        return project2;
    }

    @Override
    @Nullable
    public Project convertAndLoadProject(@NotNull String filePath) throws IOException {
        Project project2;
        String fp = ProjectManagerImpl.toCanonicalName(filePath);
        final ConversionResult conversionResult = ConversionService.getInstance().convert(fp);
        if (conversionResult.openingIsCanceled()) {
            return null;
        }
        try {
            project2 = this.loadProjectWithProgress(filePath);
            if (project2 == null) {
                return null;
            }
        }
        catch (Throwable t) {
            LOG.info(t);
            throw new IOException(t);
        }
        if (!conversionResult.conversionNotNeeded()) {
            StartupManager.getInstance((Project)project2).registerPostStartupActivity(new Runnable(){

                @Override
                public void run() {
                    conversionResult.postStartupActivity(project2);
                }
            });
        }
        return project2;
    }

    @Nullable
    private Project loadProjectWithProgress(@NotNull String filePath) {
        final ProjectImpl project2 = this.createProject(null, ProjectManagerImpl.toCanonicalName(filePath), false);
        try {
            this.myProgressManager.runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Object, RuntimeException>(){

                @Nullable
                public Project compute() {
                    ProjectManagerImpl.this.initProject(project2, null);
                    return project2;
                }
            }, ProjectBundle.message((String)"project.load.progress", (Object[])new Object[0]), ProjectManagerImpl.canCancelProjectLoading(), (Project)project2);
        }
        catch (ProcessCanceledException ignore) {
            return null;
        }
        return project2;
    }

    private static void notifyProjectOpenFailed() {
        ((AppLifecycleListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).projectOpenFailed();
        WelcomeFrame.showIfNoProjectOpened();
    }

    @Override
    public void openTestProject(@NotNull Project project2) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.openProject(project2);
        UIUtil.dispatchAllInvocationEvents();
    }

    @Override
    @NotNull
    public Collection<Project> closeTestProject(@NotNull Project project2) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.closeProject(project2, false, false, false);
        Project[] projects = this.getOpenProjects();
        return projects.length == 0 ? Collections.emptyList() : Arrays.asList(projects);
    }

    public void reloadProject(@NotNull Project project2) {
        ProjectManagerImpl.doReloadProject(project2);
    }

    public static void doReloadProject(@NotNull Project project2) {
        final Ref projectRef = Ref.create((Object)project2);
        ProjectReloadState.getInstance((Project)project2).onBeforeAutomaticProjectReload();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                LOG.debug("Reloading project.");
                Project project2 = (Project)projectRef.get();
                projectRef.set(null);
                if (project2.isDisposed()) {
                    return;
                }
                String presentableUrl = project2.getPresentableUrl();
                if (!ProjectUtil.closeAndDispose(project2)) {
                    return;
                }
                ProjectUtil.openProject(presentableUrl, null, true);
            }
        }, ModalityState.NON_MODAL);
    }

    public boolean closeProject(@NotNull Project project2) {
        return this.closeProject(project2, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeProject(final @NotNull Project project2, boolean save, final boolean dispose, boolean checkCanClose) {
        if (ProjectManagerImpl.isLight(project2)) {
            if (!((ProjectImpl)project2).isTemporarilyDisposed()) {
                ((ProjectImpl)project2).setTemporarilyDisposed(true);
                this.removeFromOpened(project2);
                return true;
            }
            ((ProjectImpl)project2).setTemporarilyDisposed(false);
        } else if (!this.isProjectOpened(project2)) {
            return true;
        }
        if (checkCanClose && !this.canClose(project2)) {
            return false;
        }
        ShutDownTracker shutDownTracker = ShutDownTracker.getInstance();
        shutDownTracker.registerStopperThread(Thread.currentThread());
        try {
            if (save) {
                FileDocumentManager.getInstance().saveAllDocuments();
                project2.save();
            }
            if (checkCanClose && !ProjectManagerImpl.ensureCouldCloseIfUnableToSave(project2)) {
                boolean bl = false;
                return bl;
            }
            this.fireProjectClosing(project2);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ProjectManagerImpl.this.removeFromOpened(project2);
                    ProjectManagerImpl.this.fireProjectClosed(project2);
                    if (dispose) {
                        Disposer.dispose((Disposable)project2);
                    }
                }
            });
        }
        finally {
            shutDownTracker.unregisterStopperThread(Thread.currentThread());
        }
        return true;
    }

    public static boolean isLight(@NotNull Project project2) {
        return project2 instanceof ProjectImpl && ((ProjectImpl)project2).isLight();
    }

    @Override
    public boolean closeAndDispose(@NotNull Project project2) {
        return this.closeProject(project2, true, true, true);
    }

    private void fireProjectClosing(@NotNull Project project2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: fireProjectClosing()");
        }
        for (ProjectManagerListener listener2 : this.myListeners) {
            try {
                listener2.projectClosing(project2);
            }
            catch (Exception e) {
                LOG.error("From listener " + listener2 + " (" + listener2.getClass() + ")", (Throwable)e);
            }
        }
    }

    public void addProjectManagerListener(@NotNull ProjectManagerListener listener2) {
        this.myListeners.add(listener2);
    }

    public void addProjectManagerListener(final @NotNull ProjectManagerListener listener2, @NotNull Disposable parentDisposable) {
        this.addProjectManagerListener(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ProjectManagerImpl.this.removeProjectManagerListener(listener2);
            }
        });
    }

    public void removeProjectManagerListener(@NotNull ProjectManagerListener listener2) {
        boolean removed = this.myListeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    public void addProjectManagerListener(@NotNull Project project2, @NotNull ProjectManagerListener listener2) {
        List listeners = (List)project2.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (listeners == null) {
            listeners = (List)((UserDataHolderEx)project2).putUserDataIfAbsent(LISTENERS_IN_PROJECT_KEY, (Object)ContainerUtil.createLockFreeCopyOnWriteList());
        }
        listeners.add(listener2);
    }

    public void removeProjectManagerListener(@NotNull Project project2, @NotNull ProjectManagerListener listener2) {
        List listeners = (List)project2.getUserData(LISTENERS_IN_PROJECT_KEY);
        LOG.assertTrue(listeners != null);
        boolean removed = listeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    private void fireProjectOpened(@NotNull Project project2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectOpened");
        }
        for (ProjectManagerListener listener2 : this.myListeners) {
            try {
                listener2.projectOpened(project2);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void fireProjectClosed(@NotNull Project project2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectClosed");
        }
        for (ProjectManagerListener listener2 : this.myListeners) {
            try {
                listener2.projectClosed(project2);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public boolean canClose(@NotNull Project project2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: canClose()");
        }
        for (ProjectManagerListener listener2 : this.myListeners) {
            try {
                if (listener2.canCloseProject(project2)) continue;
                return false;
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
        }
        return true;
    }

    private static boolean ensureCouldCloseIfUnableToSave(@NotNull Project project2) {
        VirtualFile[] files;
        UnableToSaveProjectNotification[] notifications = (UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UnableToSaveProjectNotification.class, project2);
        if (notifications.length == 0) {
            return true;
        }
        StringBuilder message = new StringBuilder();
        message.append(String.format("%s was unable to save some project files,\nare you sure you want to close this project anyway?", ApplicationNamesInfo.getInstance().getProductName()));
        message.append("\n\nRead-only files:\n");
        int count = 0;
        for (VirtualFile file2 : files = notifications[0].myFiles) {
            if (count == 10) {
                message.append('\n').append("and ").append(files.length - count).append(" more").append('\n');
                continue;
            }
            message.append(file2.getPath()).append('\n');
            ++count;
        }
        return Messages.showYesNoDialog((Project)project2, (String)message.toString(), (String)"Unsaved Project", (Icon)Messages.getWarningIcon()) == 0;
    }

    @Override
    public void saveChangedProjectFile(@NotNull VirtualFile file2, @NotNull Project project2) {
    }

    @Override
    public void blockReloadingProjectOnExternalChanges() {
    }

    @Override
    public void unblockReloadingProjectOnExternalChanges() {
    }

    public static class UnableToSaveProjectNotification
    extends Notification {
        private Project myProject;
        public VirtualFile[] myFiles;

        public UnableToSaveProjectNotification(@NotNull Project project2, @NotNull VirtualFile[] readOnlyFiles) {
            super("Project Settings", "Could not save project", "Unable to save project files. Please ensure project files are writable and you have permissions to modify them. <a href=\"\">Try to save project again</a>.", NotificationType.ERROR, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    UnableToSaveProjectNotification unableToSaveProjectNotification = (UnableToSaveProjectNotification)notification;
                    Project _project = unableToSaveProjectNotification.myProject;
                    notification.expire();
                    if (_project != null && !_project.isDisposed()) {
                        _project.save();
                    }
                }
            });
            this.myProject = project2;
            this.myFiles = readOnlyFiles;
        }

        public void expire() {
            this.myProject = null;
            super.expire();
        }
    }
}

